/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.layout.CrossTabColorShema;
import java.awt.Color;

public class TwoSeedCrossTabColorShema
extends CrossTabColorShema {
    private Color rowSeed;
    private Color columnSeed;

    public TwoSeedCrossTabColorShema(Color rowSeed, Color columnSeed) {
        this.rowSeed = rowSeed;
        this.columnSeed = columnSeed;
    }

    public void create(int numCols, int numRows) {
        int i;
        ++numCols;
        ++numRows;
        if (this.colors == null) {
            this.colors = new Color[numCols][numRows];
        }
        this.colors[numCols - 1][numRows - 2] = this.columnSeed;
        this.colors[numCols - 2][numRows - 1] = this.rowSeed;
        if (numRows >= 2) {
            for (i = numRows - 2; i >= 1; --i) {
                this.colors[numCols - 1][i - 1] = this.getDarker(this.colors[numCols - 1][i]);
            }
        }
        if (numCols >= 2) {
            for (int j = numCols - 2; j >= 1; --j) {
                this.colors[j - 1][numRows - 1] = this.getDarker(this.colors[j][numRows - 1]);
            }
        }
        for (i = numRows - 2; i >= 0; --i) {
            for (int j = numCols - 2; j >= 0; --j) {
                this.colors[j][i] = this.getDarker(this.getAvergage(this.colors[j][i + 1], this.colors[j + 1][i]));
            }
        }
    }

    private Color getAvergage(Color color, Color color2) {
        float[] comps = color.getColorComponents(null);
        float[] comps2 = color2.getColorComponents(null);
        for (int i = 0; i < comps2.length; ++i) {
            comps[i] = (float)((double)(comps[i] + comps2[i]) / 2.0);
        }
        return new Color(comps[0], comps[1], comps[2]);
    }

    private Color getDarker(Color color) {
        float pr = 0.9f;
        float[] comps = color.getColorComponents(null);
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = comps[i] * pr;
        }
        return new Color(comps[0], comps[1], comps[2]);
    }
}

