/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.subreport;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import ar.com.fdvs.dj.test.ReportExporter;
import ar.com.fdvs.dj.test.util.StyleFactory;
import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.view.JasperViewer;

public class SubreportWithParametersReportTest
extends BaseDjReportTest {
    private Connection con;

    @Override
    public DynamicReport buildReport() throws Exception {
        Style valueStyle = StyleFactory.createGroupTileStyle("gtitleTyle");
        valueStyle.setBorderBottom(Border.THIN());
        Style columnTitleStyle = StyleFactory.createGroupDetailStyle("gdetailStyle");
        Style header = StyleFactory.createHeaderStyle2("header");
        FastReportBuilder drb = new FastReportBuilder();
        drb.addColumn("City", "city", String.class.getName(), 50, valueStyle, columnTitleStyle).addColumn("Id", "id", Integer.class.getName(), 30).addColumn("Last Name", "lastname", String.class.getName(), 50).addColumn("First Name", "firstname", String.class.getName(), 30).addColumn("Street", "street", String.class.getName(), 50).addGroups(2, GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME).setGroupLayout(2, GroupLayout.EMPTY).setTitle("Customers consumptions").setPrintColumnNames(false).setDefaultStyles(null, null, header, null).setQuery("select * from customer order by city", "sql").setUseFullPageWidth(true);
        DynamicReport drLevel2 = this.createLevel2Subreport();
        SubreportParameter[] subreportParameters = new SubreportParameter[]{new SubreportParameter("custId", "id", Integer.class.getName(), 1)};
        drb.addSubreportInGroupFooter(2, drLevel2, (LayoutManager)new ClassicLayoutManager(), null, 10, 100, subreportParameters);
        this.dr = drb.build();
        this.params.put("nom", "Juan");
        return this.dr;
    }

    private DynamicReport createLevel2Subreport() throws Exception {
        Style vstyle1 = StyleFactory.createGroupVariableStyle("v1g");
        Style vstyle = StyleFactory.createGroup2VariableStyle("v2g");
        Style header = StyleFactory.createHeaderStyle2("s1header");
        header.setTransparency(Transparency.TRANSPARENT);
        vstyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        FastReportBuilder rb = new FastReportBuilder();
        DynamicReport dr = rb.addColumn("Invoice", "invoiceid", Long.class.getName(), 40).addColumn("Descpription", "name", String.class.getName(), 200).addColumn("Quantity", "quantity", Integer.class.getName(), 50).addColumn("Cost", "cost", Float.class.getName(), 80).addColumn("Total", "itemtotal", Float.class.getName(), 80).addGroups(1).addGlobalFooterVariable(3, DJCalculation.SUM, vstyle1).addGlobalFooterVariable(4, DJCalculation.SYSTEM, vstyle1).addGlobalFooterVariable(5, DJCalculation.SUM, vstyle1).addFooterVariable(1, 3, DJCalculation.SUM, vstyle).addFooterVariable(1, 4, DJCalculation.SYSTEM, vstyle).addFooterVariable(1, 5, DJCalculation.SUM, vstyle).setQuery("SELECT a.quantity, a.cost, b.name, b.price, a.invoiceid,  a.cost * b.price itemtotal, c.customerid  FROM item a, product b, invoice c where a.productid = b.id and a.invoiceId = c.id and c.customerid = $P{custId} order by a.invoiceid, item", "sql").setUseFullPageWidth(false).setDefaultStyles(null, null, header, null).addParameter("custId", Integer.class.getName()).setWhenNoData("No invoices for this customer", null).setMargins(0, 0, 30, 30).build();
        return dr;
    }

    public static void main(String[] args) throws Exception {
        SubreportWithParametersReportTest test = new SubreportWithParametersReportTest();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
        String jrxml = JRXmlWriter.writeReport((JRReport)test.jr, (String)"UTF-8");
        System.out.println(jrxml);
    }

    @Override
    public void testReport() throws Exception {
        try {
            this.con = SubreportWithParametersReportTest.createSQLConnection();
            this.dr = this.buildReport();
            this.jp = DynamicJasperHelper.generateJasperPrint((DynamicReport)this.dr, (LayoutManager)new ClassicLayoutManager(), (Connection)this.con, (Map)this.params);
            ReportExporter.exportReport(this.jp, System.getProperty("user.dir") + "/target/" + ((Object)((Object)this)).getClass().getName() + ".pdf");
            this.jr = DynamicJasperHelper.generateJasperReport((DynamicReport)this.dr, (LayoutManager)new ClassicLayoutManager(), (Map)this.params);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.con != null) {
                this.con.close();
            }
        }
    }
}

