/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.domain.chart.builder;

import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.builder.DJXYLineChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.view.JasperViewer;

public class XYLineChartBuilderTest
extends BaseDjReportTest {
    private DynamicReportBuilder drb;
    private JRDesignChart chart;

    protected void setUp() throws Exception {
        this.drb = new DynamicReportBuilder();
        Style headerStyle = new Style();
        headerStyle.setFont(Font.VERDANA_MEDIUM_BOLD);
        headerStyle.setBorderBottom(Border.PEN_2_POINT());
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setBackgroundColor(Color.DARK_GRAY);
        headerStyle.setTextColor(Color.WHITE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        this.drb.setDefaultStyles(null, null, headerStyle, null);
        AbstractColumn columnCode = ColumnBuilder.getNew().setColumnProperty("id", Long.class.getName()).setTitle("ID").setWidth(new Integer(40)).build();
        AbstractColumn columnaQuantity = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80)).build();
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90)).build();
        this.drb.addColumn(columnCode);
        this.drb.addColumn(columnaQuantity);
        this.drb.addColumn(columnAmount);
        this.drb.setUseFullPageWidth(true);
        DJAxisFormat categoryAxisFormat = new DJAxisFormat("x");
        categoryAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        categoryAxisFormat.setLabelColor(Color.DARK_GRAY);
        categoryAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        categoryAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        categoryAxisFormat.setTickLabelMask("#,###.#");
        categoryAxisFormat.setLineColor(Color.DARK_GRAY);
        DJAxisFormat valueAxisFormat = new DJAxisFormat("value");
        valueAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelMask("#,##0.0");
        valueAxisFormat.setLineColor(Color.DARK_GRAY);
        DJChart djChart = new DJXYLineChartBuilder().setX(20).setY(10).setWidth(500).setHeight(250).setCentered(false).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitle("title").setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setSubtitle("subtitle").setSubtitleColor(Color.DARK_GRAY).setSubtitleFont(Font.COURIER_NEW_BIG_BOLD).setLegendColor(Color.DARK_GRAY).setLegendFont(Font.COURIER_NEW_MEDIUM_BOLD).setLegendBackgroundColor(Color.WHITE).setLegendPosition(DJChartOptions.EDGE_BOTTOM).setTitlePosition(DJChartOptions.EDGE_TOP).setLineStyle(DJChartOptions.LINE_STYLE_DOTTED).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setXValue((PropertyColumn)columnCode).addSerie(columnaQuantity, "quant.").addSerie(columnAmount).setShowShapes(true).setShowLines(true).setCategoryAxisFormat(categoryAxisFormat).setValueAxisFormat(valueAxisFormat).build();
        this.drb.addChart(djChart);
        DJHyperLink djlink = new DJHyperLink();
        djlink.setExpression(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "http://thisIsAURL?count=" + variables.get("REPORT_COUNT");
            }
        });
        djlink.setTooltip((StringExpression)new LiteralExpression("I'm a literal tootltip"));
        djChart.setLink(djlink);
        HashMap<AbstractColumn, JRDesignVariable> vars = new HashMap<AbstractColumn, JRDesignVariable>();
        vars.put(columnaQuantity, new JRDesignVariable());
        vars.put(columnAmount, new JRDesignVariable());
        JRDesignGroup group = new JRDesignGroup();
        this.chart = djChart.transform(new DynamicJasperDesign(), "", group, group, vars, 0);
    }

    public void testChart() {
        XYLineChartBuilderTest.assertEquals((int)20, (int)this.chart.getX());
        XYLineChartBuilderTest.assertEquals((int)10, (int)this.chart.getY());
        XYLineChartBuilderTest.assertEquals((int)500, (int)this.chart.getWidth());
        XYLineChartBuilderTest.assertEquals((int)250, (int)this.chart.getHeight());
        XYLineChartBuilderTest.assertEquals((Object)Color.LIGHT_GRAY, (Object)this.chart.getBackcolor());
        XYLineChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)this.chart.getShowLegend());
        XYLineChartBuilderTest.assertNotNull((Object)this.chart.getTitleExpression().getText());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getTitleColor());
        this.testFont(Font.ARIAL_BIG_BOLD, this.chart.getTitleFont());
        XYLineChartBuilderTest.assertNotNull((Object)this.chart.getSubtitleExpression().getText());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getSubtitleColor());
        this.testFont(Font.COURIER_NEW_BIG_BOLD, this.chart.getSubtitleFont());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLegendColor());
        this.testFont(Font.COURIER_NEW_MEDIUM_BOLD, this.chart.getLegendFont());
        XYLineChartBuilderTest.assertEquals((Object)Color.WHITE, (Object)this.chart.getLegendBackgroundColor());
        XYLineChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_BOTTOM), (Object)this.chart.getLegendPositionValue().getValueByte());
        XYLineChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_TOP), (Object)this.chart.getTitlePositionValue().getValueByte());
        XYLineChartBuilderTest.assertEquals((Object)LineStyleEnum.getByValue((Byte)new Byte(DJChartOptions.LINE_STYLE_DOTTED)), (Object)this.chart.getLineBox().getPen().getLineStyleValue());
        XYLineChartBuilderTest.assertEquals((Object)new Float(1.0f), (Object)this.chart.getLineBox().getPen().getLineWidth());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLineBox().getPen().getLineColor());
        XYLineChartBuilderTest.assertEquals((Object)new Integer(5), (Object)this.chart.getLineBox().getPadding());
    }

    public void testDataset() {
        JRDesignXyDataset dataset = (JRDesignXyDataset)this.chart.getDataset();
        XYLineChartBuilderTest.assertEquals((int)2, (int)dataset.getSeriesList().size());
        XYLineChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getLabelExpression().getText());
        XYLineChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getSeriesExpression().getText());
    }

    public void testPlot() {
        JRDesignLinePlot plot = (JRDesignLinePlot)this.chart.getPlot();
        XYLineChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)plot.getShowLines());
        XYLineChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)plot.getShowShapes());
        XYLineChartBuilderTest.assertNotNull((Object)plot.getCategoryAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getCategoryAxisLabelFont());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getCategoryAxisTickLabelFont());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisTickLabelColor());
        XYLineChartBuilderTest.assertEquals((String)"#,###.#", (String)plot.getCategoryAxisTickLabelMask());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisLineColor());
        XYLineChartBuilderTest.assertNotNull((Object)plot.getValueAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisLabelFont());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisTickLabelFont());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisTickLabelColor());
        XYLineChartBuilderTest.assertEquals((String)"#,##0.0", (String)plot.getValueAxisTickLabelMask());
        XYLineChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLineColor());
    }

    @Override
    public DynamicReport buildReport() throws Exception {
        return this.drb.build();
    }

    private void testFont(Font djFont, JRFont jrFont) {
        XYLineChartBuilderTest.assertEquals((String)djFont.getFontName(), (String)jrFont.getFontName());
        XYLineChartBuilderTest.assertEquals((int)djFont.getFontSize(), (int)jrFont.getFontSize());
        XYLineChartBuilderTest.assertEquals((boolean)djFont.isBold(), (boolean)jrFont.isBold());
        XYLineChartBuilderTest.assertEquals((boolean)djFont.isItalic(), (boolean)jrFont.isItalic());
    }

    public static void main(String[] args) throws Exception {
        XYLineChartBuilderTest test = new XYLineChartBuilderTest();
        test.setUp();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

