/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.domain.chart.builder;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.builder.DJAreaChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.view.JasperViewer;

public class AbstractChartBuilderTest
extends BaseDjReportTest {
    private DynamicReportBuilder drb;
    private JRDesignChart chart;

    protected void setUp() throws Exception {
        this.drb = new DynamicReportBuilder();
        AbstractColumn columnState = ColumnBuilder.getNew().setColumnProperty("state", String.class.getName()).setTitle("State").setWidth(new Integer(85)).build();
        AbstractColumn columnBranch = ColumnBuilder.getNew().setColumnProperty("branch", String.class.getName()).setTitle("Branch").setWidth(new Integer(85)).build();
        AbstractColumn columnaQuantity = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80)).build();
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90)).build();
        this.drb.addColumn(columnState);
        this.drb.addColumn(columnBranch);
        this.drb.addColumn(columnaQuantity);
        this.drb.addColumn(columnAmount);
        GroupBuilder gb1 = new GroupBuilder();
        DJGroup g1 = gb1.setCriteriaColumn((PropertyColumn)columnState).addFooterVariable(columnAmount, DJCalculation.SUM).addFooterVariable(columnaQuantity, DJCalculation.SUM).addVariable("group_state_name", columnState, DJCalculation.FIRST).setGroupLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS).build();
        this.drb.addGroup(g1);
        this.drb.setUseFullPageWidth(true);
        DJAxisFormat categoryAxisFormat = new DJAxisFormat("category");
        categoryAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        categoryAxisFormat.setLabelColor(Color.DARK_GRAY);
        categoryAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        categoryAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        categoryAxisFormat.setTickLabelMask("");
        categoryAxisFormat.setLineColor(Color.DARK_GRAY);
        DJAxisFormat valueAxisFormat = new DJAxisFormat("value");
        valueAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelMask("#,##0.0");
        valueAxisFormat.setLineColor(Color.DARK_GRAY);
        DJAreaChartBuilder builder = new DJAreaChartBuilder();
        builder.setX(20).setY(10).setWidth(500).setHeight(250).setCentered(false).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitle(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return variables.get("group_state_name");
            }
        }).setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setSubtitle("subtitle").setSubtitleColor(Color.DARK_GRAY).setSubtitleFont(Font.COURIER_NEW_BIG_BOLD).setLegendColor(Color.DARK_GRAY).setLegendFont(Font.COURIER_NEW_MEDIUM_BOLD).setLegendBackgroundColor(Color.WHITE).setLegendPosition(DJChartOptions.EDGE_BOTTOM).setTitlePosition(DJChartOptions.EDGE_TOP).setLineStyle(DJChartOptions.LINE_STYLE_DOTTED).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).addSerie(columnAmount).setColumnGroup((PropertyColumn)columnBranch);
        DJChart djChart = builder.addSerie(columnaQuantity, "quant.").setCategoryAxisFormat(categoryAxisFormat).setValueAxisFormat(valueAxisFormat).build();
        this.drb.addChart(djChart);
        DJHyperLink djlink = new DJHyperLink();
        djlink.setExpression(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "http://thisIsAURL?count=" + variables.get("REPORT_COUNT");
            }
        });
        djlink.setTooltip((StringExpression)new LiteralExpression("I'm a literal tootltip"));
        djChart.setLink(djlink);
        HashMap<AbstractColumn, JRDesignVariable> vars = new HashMap<AbstractColumn, JRDesignVariable>();
        vars.put(columnaQuantity, new JRDesignVariable());
        vars.put(columnAmount, new JRDesignVariable());
        JRDesignGroup group = new JRDesignGroup();
        this.chart = djChart.transform(new DynamicJasperDesign(), "", group, group, vars, 0);
    }

    public void testChart() {
        AbstractChartBuilderTest.assertEquals((int)20, (int)this.chart.getX());
        AbstractChartBuilderTest.assertEquals((int)10, (int)this.chart.getY());
        AbstractChartBuilderTest.assertEquals((int)500, (int)this.chart.getWidth());
        AbstractChartBuilderTest.assertEquals((int)250, (int)this.chart.getHeight());
        AbstractChartBuilderTest.assertEquals((Object)Color.LIGHT_GRAY, (Object)this.chart.getBackcolor());
        AbstractChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)this.chart.getShowLegend());
        AbstractChartBuilderTest.assertNotNull((Object)this.chart.getTitleExpression().getText());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getTitleColor());
        this.testFont(Font.ARIAL_BIG_BOLD, this.chart.getTitleFont());
        AbstractChartBuilderTest.assertNotNull((Object)this.chart.getSubtitleExpression().getText());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getSubtitleColor());
        this.testFont(Font.COURIER_NEW_BIG_BOLD, this.chart.getSubtitleFont());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLegendColor());
        this.testFont(Font.COURIER_NEW_MEDIUM_BOLD, this.chart.getLegendFont());
        AbstractChartBuilderTest.assertEquals((Object)Color.WHITE, (Object)this.chart.getLegendBackgroundColor());
        AbstractChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_BOTTOM), (Object)this.chart.getLegendPositionValue().getValueByte());
        AbstractChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_TOP), (Object)this.chart.getTitlePositionValue().getValueByte());
        AbstractChartBuilderTest.assertEquals((Object)LineStyleEnum.getByValue((Byte)new Byte(DJChartOptions.LINE_STYLE_DOTTED)), (Object)this.chart.getLineBox().getPen().getLineStyleValue());
        AbstractChartBuilderTest.assertEquals((Object)new Float(1.0f), (Object)this.chart.getLineBox().getPen().getLineWidth());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLineBox().getPen().getLineColor());
        AbstractChartBuilderTest.assertEquals((Object)new Integer(5), (Object)this.chart.getLineBox().getPadding());
    }

    public void testDataset() {
        JRDesignCategoryDataset dataset = (JRDesignCategoryDataset)this.chart.getDataset();
        AbstractChartBuilderTest.assertEquals((int)2, (int)dataset.getSeriesList().size());
        AbstractChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getLabelExpression().getText());
        AbstractChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getSeriesExpression().getText());
    }

    public void testPlot() {
        JRDesignAreaPlot plot = (JRDesignAreaPlot)this.chart.getPlot();
        AbstractChartBuilderTest.assertNotNull((Object)plot.getCategoryAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getCategoryAxisLabelFont());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getCategoryAxisTickLabelFont());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisTickLabelColor());
        AbstractChartBuilderTest.assertEquals((String)"", (String)plot.getCategoryAxisTickLabelMask());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisLineColor());
        AbstractChartBuilderTest.assertNotNull((Object)plot.getValueAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisLabelFont());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisTickLabelFont());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisTickLabelColor());
        AbstractChartBuilderTest.assertEquals((String)"#,##0.0", (String)plot.getValueAxisTickLabelMask());
        AbstractChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLineColor());
    }

    @Override
    public DynamicReport buildReport() throws Exception {
        return this.drb.build();
    }

    private void testFont(Font djFont, JRFont jrFont) {
        AbstractChartBuilderTest.assertEquals((String)djFont.getFontName(), (String)jrFont.getFontName());
        AbstractChartBuilderTest.assertEquals((int)djFont.getFontSize(), (int)jrFont.getFontSize());
        AbstractChartBuilderTest.assertEquals((boolean)djFont.isBold(), (boolean)jrFont.isBold());
        AbstractChartBuilderTest.assertEquals((boolean)djFont.isItalic(), (boolean)jrFont.isItalic());
    }

    public static void main(String[] args) throws Exception {
        AbstractChartBuilderTest test = new AbstractChartBuilderTest();
        test.setUp();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

