/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.customexpression.DJSimpleExpression;
import ar.com.fdvs.dj.domain.entities.DJVariable;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.util.Date;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperDesignViewer;
import net.sf.jasperreports.view.JasperViewer;

public class ReportWithVariablesTest
extends BaseDjReportTest {
    @Override
    public DynamicReport buildReport() throws Exception {
        Style style = new Style("currency");
        style.setHorizontalAlign(HorizontalAlign.RIGHT);
        style.setPattern("$ #,###.00");
        FastReportBuilder drb = new FastReportBuilder();
        drb.addColumn("State", "state", String.class.getName(), 30).addColumn("Branch", "branch", String.class.getName(), 30).addColumn("Product Line", "productLine", String.class.getName(), 50).addColumn("Item", "item", String.class.getName(), 50).addColumn("Item Code", "id", Long.class.getName(), 30, true).addColumn("Quantity", "quantity", Long.class.getName(), 60, true).addColumn("Amount", "amount", Float.class.getName(), 70, true).addColumn("Balance", (CustomExpression)new DJSimpleExpression(1, "acum", Float.class.getName()), 80, false, null, style).addVariable("acum", DJCalculation.SUM, (CustomExpression)new DJSimpleExpression(0, "amount", Float.class.getName())).addGroups(2).setTitle("November " + this.getYear() + " sales report").setSubtitle("This report was generated at " + new Date()).setPrintBackgroundOnOddRows(true).setUseFullPageWidth(true);
        DynamicReport dr = drb.build();
        return dr;
    }

    private DJVariable createVariable() {
        DJSimpleExpression expression = new DJSimpleExpression(0, "amount", Float.class.getName());
        DJVariable var = new DJVariable("acum", Float.class.getName(), DJCalculation.SUM, (CustomExpression)expression);
        return var;
    }

    public static void main(String[] args) throws Exception {
        ReportWithVariablesTest test = new ReportWithVariablesTest();
        test.testReport();
        test.exportToJRXML();
        JasperViewer.viewReport((JasperPrint)test.jp);
        JasperDesignViewer.viewReportDesign((JRReport)test.jr);
    }
}

