/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportExporter {
    private static final Log logger = LogFactory.getLog(ReportExporter.class);

    public static void exportReport(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        logger.debug((Object)("Exporing report to: " + path));
        JRPdfExporter exporter = new JRPdfExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        SimpleExporterInput simpleExporterInput = new SimpleExporterInput(jp);
        SimpleOutputStreamExporterOutput simpleOutputStreamExporterOutput = new SimpleOutputStreamExporterOutput((OutputStream)fos);
        exporter.setExporterInput((ExporterInput)simpleExporterInput);
        exporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
        exporter.exportReport();
        logger.debug((Object)("Report exported: " + path));
    }

    public static void exportReportXls(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        JRXlsExporter exporter = new JRXlsExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)configuration);
        configuration.setDetectCellType(Boolean.valueOf(true));
        configuration.setWhitePageBackground(Boolean.valueOf(false));
        configuration.setIgnoreGraphics(Boolean.valueOf(false));
        SimpleExporterInput simpleExporterInput = new SimpleExporterInput(jp);
        SimpleOutputStreamExporterOutput simpleOutputStreamExporterOutput = new SimpleOutputStreamExporterOutput((OutputStream)fos);
        exporter.setExporterInput((ExporterInput)simpleExporterInput);
        exporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
        exporter.exportReport();
        logger.debug((Object)("Xlsx Report exported: " + path));
    }

    public static void exportReportHtml(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        JRHtmlExporter exporter = new JRHtmlExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fos);
        exporter.exportReport();
        logger.debug((Object)("HTML Report exported: " + path));
    }

    public static void exportReportPlainXls(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        JExcelApiExporter exporter = new JExcelApiExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fos);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.exportReport();
        logger.debug((Object)("Report exported: " + path));
    }
}

