/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.constants.DJVariableIncrementType;
import ar.com.fdvs.dj.domain.constants.DJVariableResetType;
import ar.com.fdvs.dj.domain.entities.DJVariable;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.LayoutUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;

public class VariableRegistrationManager
extends AbstractEntityRegistrationManager {
    public VariableRegistrationManager(DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager) {
        super(jd, dr, layoutManager);
    }

    protected void registerEntity(Entity entity) {
        try {
            JRDesignVariable jrvar = (JRDesignVariable)this.transformEntity(entity);
            this.getDjd().addVariable(jrvar);
        }
        catch (JRException e) {
            throw new DJException("Problem registering a DJVariable: " + e.getMessage(), e);
        }
    }

    protected Object transformEntity(Entity entity) throws JRException {
        JRDesignGroup jrgroup;
        DJVariable var = (DJVariable)entity;
        JRDesignVariable jrvar = new JRDesignVariable();
        jrvar.setName(var.getName());
        jrvar.setValueClassName(var.getClassName());
        if (var.getCalculation() != null) {
            jrvar.setCalculation(CalculationEnum.getByValue((byte)var.getCalculation().getValue()));
        }
        String expressionParamName = var.getName() + "_expression";
        JRDesignExpression expression = ExpressionUtils.createAndRegisterExpression(this.getDjd(), expressionParamName, var.getExpression());
        jrvar.setExpression((JRExpression)expression);
        if (var.getInitialValueExpression() != null) {
            String initialValueExpressionParamName = var.getName() + "_initalValueExpression";
            JRDesignExpression initialValueExpression = ExpressionUtils.createAndRegisterExpression(this.getDjd(), initialValueExpressionParamName, var.getInitialValueExpression());
            jrvar.setExpression((JRExpression)initialValueExpression);
        }
        if (var.getResetType() != null) {
            jrvar.setResetType(ResetTypeEnum.getByValue((byte)var.getResetType().getValue()));
        }
        if (var.getResetGroup() != null && DJVariableResetType.GROUP.equals(var.getResetType())) {
            jrgroup = LayoutUtils.getJRDesignGroup(this.getDjd(), this.getLayoutManager(), var.getResetGroup());
            jrvar.setResetGroup((JRGroup)jrgroup);
        }
        if (var.getIncrementType() != null) {
            jrvar.setIncrementType(IncrementTypeEnum.getByValue((byte)var.getIncrementType().getValue()));
        }
        if (var.getIncrementGroup() != null && DJVariableIncrementType.GROUP.equals(var.getIncrementType())) {
            jrgroup = LayoutUtils.getJRDesignGroup(this.getDjd(), this.getLayoutManager(), var.getResetGroup());
            jrvar.setIncrementGroup((JRGroup)jrgroup);
        }
        return jrvar;
    }
}

