/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.domain.chart.builder;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.builder.DJTimeSeriesChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.view.JasperViewer;
import org.jfree.data.time.Month;

public class TimeSeriesChartBuilderTest
extends BaseDjReportTest {
    private DynamicReportBuilder drb;
    private JRDesignChart chart;

    protected void setUp() throws Exception {
        this.drb = new DynamicReportBuilder();
        Style headerStyle = new Style();
        headerStyle.setFont(Font.VERDANA_MEDIUM_BOLD);
        headerStyle.setBorderBottom(Border.PEN_2_POINT());
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setBackgroundColor(Color.DARK_GRAY);
        headerStyle.setTextColor(Color.WHITE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        this.drb.setDefaultStyles(null, null, headerStyle, null);
        AbstractColumn columnDate = ColumnBuilder.getNew().setColumnProperty("date", Date.class.getName()).setTitle("Date").setWidth(new Integer(85)).build();
        AbstractColumn columnaQuantity = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80)).build();
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90)).build();
        this.drb.addColumn(columnDate);
        this.drb.addColumn(columnaQuantity);
        this.drb.addColumn(columnAmount);
        this.drb.addGlobalVariable("min_date", columnDate, DJCalculation.LOWEST);
        this.drb.addGlobalVariable("max_date", columnDate, DJCalculation.HIGHEST);
        this.drb.setUseFullPageWidth(true);
        DJAxisFormat timeAxisFormat = new DJAxisFormat("date");
        timeAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        timeAxisFormat.setLabelColor(Color.DARK_GRAY);
        timeAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        timeAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        timeAxisFormat.setTickLabelMask("MMM-yy");
        timeAxisFormat.setLineColor(Color.DARK_GRAY);
        DJAxisFormat valueAxisFormat = new DJAxisFormat("value");
        valueAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelMask("#,##0.0");
        valueAxisFormat.setLineColor(Color.DARK_GRAY);
        DJChart djChart = new DJTimeSeriesChartBuilder().setX(20).setY(10).setWidth(500).setHeight(250).setCentered(false).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitle(new StringExpression(){
            private SimpleDateFormat format = new SimpleDateFormat("MMMM yyyy");

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "From " + this.format.format((Date)variables.get("min_date")) + " to " + this.format.format((Date)variables.get("max_date"));
            }
        }).setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setSubtitle("subtitle").setSubtitleColor(Color.DARK_GRAY).setSubtitleFont(Font.COURIER_NEW_BIG_BOLD).setLegendColor(Color.DARK_GRAY).setLegendFont(Font.COURIER_NEW_MEDIUM_BOLD).setLegendBackgroundColor(Color.WHITE).setLegendPosition(DJChartOptions.EDGE_BOTTOM).setTitlePosition(DJChartOptions.EDGE_TOP).setLineStyle(DJChartOptions.LINE_STYLE_DOTTED).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setTimePeriod((PropertyColumn)columnDate).setTimePeriodClass(Month.class).addSerie(columnaQuantity, "quant.").addSerie(columnAmount).setShowShapes(true).setShowLines(true).setTimeAxisFormat(timeAxisFormat).setValueAxisFormat(valueAxisFormat).build();
        this.drb.addChart(djChart);
        DJHyperLink djlink = new DJHyperLink();
        djlink.setExpression(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "http://thisIsAURL?count=" + variables.get("REPORT_COUNT");
            }
        });
        djlink.setTooltip((StringExpression)new LiteralExpression("I'm a literal tootltip"));
        djChart.setLink(djlink);
        HashMap<AbstractColumn, JRDesignVariable> vars = new HashMap<AbstractColumn, JRDesignVariable>();
        vars.put(columnaQuantity, new JRDesignVariable());
        vars.put(columnAmount, new JRDesignVariable());
        JRDesignGroup group = new JRDesignGroup();
        this.chart = djChart.transform(new DynamicJasperDesign(), "", group, group, vars, 0);
    }

    public void testChart() {
        TimeSeriesChartBuilderTest.assertEquals((int)20, (int)this.chart.getX());
        TimeSeriesChartBuilderTest.assertEquals((int)10, (int)this.chart.getY());
        TimeSeriesChartBuilderTest.assertEquals((int)500, (int)this.chart.getWidth());
        TimeSeriesChartBuilderTest.assertEquals((int)250, (int)this.chart.getHeight());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.LIGHT_GRAY, (Object)this.chart.getBackcolor());
        TimeSeriesChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)this.chart.getShowLegend());
        TimeSeriesChartBuilderTest.assertNotNull((Object)this.chart.getTitleExpression().getText());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getTitleColor());
        this.testFont(Font.ARIAL_BIG_BOLD, this.chart.getTitleFont());
        TimeSeriesChartBuilderTest.assertNotNull((Object)this.chart.getSubtitleExpression().getText());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getSubtitleColor());
        this.testFont(Font.COURIER_NEW_BIG_BOLD, this.chart.getSubtitleFont());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLegendColor());
        this.testFont(Font.COURIER_NEW_MEDIUM_BOLD, this.chart.getLegendFont());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.WHITE, (Object)this.chart.getLegendBackgroundColor());
        TimeSeriesChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_BOTTOM), (Object)this.chart.getLegendPositionValue().getValueByte());
        TimeSeriesChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_TOP), (Object)this.chart.getTitlePositionValue().getValueByte());
        TimeSeriesChartBuilderTest.assertEquals((Object)LineStyleEnum.getByValue((Byte)new Byte(DJChartOptions.LINE_STYLE_DOTTED)), (Object)this.chart.getLineBox().getPen().getLineStyleValue());
        TimeSeriesChartBuilderTest.assertEquals((Object)new Float(1.0f), (Object)this.chart.getLineBox().getPen().getLineWidth());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLineBox().getPen().getLineColor());
        TimeSeriesChartBuilderTest.assertEquals((Object)new Integer(5), (Object)this.chart.getLineBox().getPadding());
    }

    public void testDataset() {
        JRDesignTimeSeriesDataset dataset = (JRDesignTimeSeriesDataset)this.chart.getDataset();
        TimeSeriesChartBuilderTest.assertEquals(Month.class, (Object)dataset.getTimePeriod());
        TimeSeriesChartBuilderTest.assertEquals((int)2, (int)dataset.getSeriesList().size());
        TimeSeriesChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getLabelExpression().getText());
        TimeSeriesChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getSeriesExpression().getText());
    }

    public void testPlot() {
        JRDesignTimeSeriesPlot plot = (JRDesignTimeSeriesPlot)this.chart.getPlot();
        TimeSeriesChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)plot.getShowShapes());
        TimeSeriesChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)plot.getShowLines());
        TimeSeriesChartBuilderTest.assertNotNull((Object)plot.getTimeAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getTimeAxisLabelFont());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getTimeAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getTimeAxisTickLabelFont());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getTimeAxisTickLabelColor());
        TimeSeriesChartBuilderTest.assertEquals((String)"MMM-yy", (String)plot.getTimeAxisTickLabelMask());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getTimeAxisLineColor());
        TimeSeriesChartBuilderTest.assertNotNull((Object)plot.getValueAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisLabelFont());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisTickLabelFont());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisTickLabelColor());
        TimeSeriesChartBuilderTest.assertEquals((String)"#,##0.0", (String)plot.getValueAxisTickLabelMask());
        TimeSeriesChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLineColor());
    }

    public DynamicReport buildReport() throws Exception {
        return this.drb.build();
    }

    private void testFont(Font djFont, JRFont jrFont) {
        TimeSeriesChartBuilderTest.assertEquals((String)djFont.getFontName(), (String)jrFont.getFontName());
        TimeSeriesChartBuilderTest.assertEquals((int)djFont.getFontSize(), (int)jrFont.getFontSize());
        TimeSeriesChartBuilderTest.assertEquals((boolean)djFont.isBold(), (boolean)jrFont.isBold());
        TimeSeriesChartBuilderTest.assertEquals((boolean)djFont.isItalic(), (boolean)jrFont.isItalic());
    }

    public static void main(String[] args) throws Exception {
        TimeSeriesChartBuilderTest test = new TimeSeriesChartBuilderTest();
        test.setUp();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }

    protected JRDataSource getDataSource() {
        ArrayList<Product> col = new ArrayList<Product>();
        try {
            col.add(new Product("1.2008", "Harry Potter 7", new Long("2500"), new Float("10000")));
            col.add(new Product("2.2008", "Harry Potter 7", new Long("1400"), new Float("2831.32")));
            col.add(new Product("3.2008", "Harry Potter 7", new Long("4000"), new Float("38347")));
            col.add(new Product("4.2008", "Harry Potter 7", new Long("3000"), new Float("9482.4")));
            col.add(new Product("5.2008", "Harry Potter 7", new Long("2500"), new Float("27475.5")));
            col.add(new Product("6.2008", "Harry Potter 7", new Long("1400"), new Float("3322")));
            col.add(new Product("7.2008", "Harry Potter 7", new Long("4000"), new Float("78482")));
            col.add(new Product("8.2008", "Harry Potter 7", new Long("3000"), new Float("5831.32")));
            col.add(new Product("9.2008", "Harry Potter 7", new Long("1500"), new Float("8329.2")));
            col.add(new Product("10.2008", "Harry Potter 7", new Long("2500"), new Float("27475.5")));
            col.add(new Product("11.2008", "Harry Potter 7", new Long("2500"), new Float("38347")));
            col.add(new Product("12.2008", "Harry Potter 7", new Long("1400"), new Float("9482.4")));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new JRBeanCollectionDataSource(col);
    }

    public class Product {
        private Date date;
        private String item;
        private Long quantity;
        private Float amount;

        Product(String date, String item, Long quantity, Float amount) throws ParseException {
            this.date = new SimpleDateFormat("MM.yyyy").parse(date);
            this.item = item;
            this.quantity = quantity;
            this.amount = amount;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getItem() {
            return this.item;
        }

        public void setItem(String item) {
            this.item = item;
        }

        public Long getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        public Float getAmount() {
            return this.amount;
        }

        public void setAmount(Float amount) {
            this.amount = amount;
        }
    }
}

