/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.crosstab;

import ar.com.fdvs.dj.core.layout.CrossTabColorShema;
import ar.com.fdvs.dj.core.layout.TwoSeedCrossTabColorShema;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.CrosstabBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import ar.com.fdvs.dj.test.TestRepositoryProducts;
import ar.com.fdvs.dj.util.SortUtils;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

public class CrosstabReportWithPercentageMeasure
extends BaseDjReportTest {
    private Style totalHeaderStyle;
    private Style rowHeaderStyle;
    private Style colHeaderStyle;
    private Style mainHeaderStyle;
    private Style totalStyle;
    private Style measureStyle;
    private Style measureStyle2;
    private Style titleStyle;
    Color pastelYellow = new Color(240, 248, 200);
    Color pastelGreen = new Color(200, 248, 240);
    Color pastelR = new Color(200, 240, 248);

    public DynamicReport buildReport() throws Exception {
        this.initStyles();
        FastReportBuilder drb = new FastReportBuilder();
        drb.setTitle("November 2006 sales report").setSubtitle("This report was generated at " + new Date()).setPageSizeAndOrientation(Page.Page_A4_Landscape()).setPrintColumnNames(false).setUseFullPageWidth(true).setWhenNoDataAllSectionNoDetail().setDefaultStyles(this.titleStyle, null, null, null);
        TwoSeedCrossTabColorShema colorScheme = new TwoSeedCrossTabColorShema(this.pastelYellow, this.pastelGreen);
        DJValueFormatter valueFormatter = new DJValueFormatter(){
            DecimalFormat dc = new DecimalFormat("#0.0");

            public String getClassName() {
                return String.class.getName();
            }

            public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
                return "" + this.dc.format(value) + " %";
            }
        };
        DJCrosstab djcross = new CrosstabBuilder().setHeight(400).setWidth(700).setHeaderStyle(this.mainHeaderStyle).useMainReportDatasource(false).setUseFullWidth(true).setColorScheme((CrossTabColorShema)colorScheme).setAutomaticTitle(true).setCellBorder(Border.PEN_1_POINT()).addRow("State", "state", String.class.getName(), true).addColumn("Product Line", "productLine", String.class.getName(), true).addMeasure("amount", Float.class.getName(), DJCalculation.SUM, "Amount", this.measureStyle2, false).addMeasure("amount", Float.class.getName(), DJCalculation.SUM, "%", this.measureStyle2, valueFormatter, true).setRowStyles(this.rowHeaderStyle, this.totalStyle, this.totalHeaderStyle).setColumnStyles(this.colHeaderStyle, this.totalStyle, this.totalHeaderStyle).setCellDimension(34, 70).setColumnHeaderHeight(30).setRowHeaderWidth(80).setDatasource("sr", 0, 0, true).build();
        drb.addHeaderCrosstab(djcross);
        DynamicReport dr = drb.build();
        List sortedCollection = SortUtils.sortCollection((Collection)TestRepositoryProducts.getDummyCollection(), (DJCrosstab)djcross);
        log.info((Object)("crosstab datasource has " + sortedCollection.size() + " elements"));
        this.params.put("sr", sortedCollection);
        return dr;
    }

    protected JRDataSource getDataSource() {
        return null;
    }

    private void initStyles() {
        this.titleStyle = new StyleBuilder(false).setFont(Font.ARIAL_BIG_BOLD).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.MIDDLE).setTransparency(Transparency.OPAQUE).setBorderBottom(Border.PEN_2_POINT()).build();
        this.totalHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_MEDIUM_BOLD).setTransparency(Transparency.OPAQUE).setTextColor(Color.BLUE).setBackgroundColor(this.pastelR).build();
        this.rowHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.TOP).setFont(Font.ARIAL_MEDIUM_BOLD).setBackgroundColor(new Color(240, 248, 255)).setBackgroundColor(this.pastelYellow).build();
        this.colHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.TOP).setFont(Font.ARIAL_MEDIUM_BOLD).setBackgroundColor(new Color(255, 240, 248)).setBackgroundColor(this.pastelGreen).build();
        this.mainHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_BIG_BOLD).setTextColor(Color.BLACK).build();
        this.totalStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM_BOLD).build();
        this.measureStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM).setBackgroundColor(Color.WHITE).build();
        this.measureStyle2 = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(new Font(10, "Arial", false, true, false)).setTextColor(Color.RED).build();
    }

    public static void main(String[] args) throws Exception {
        CrosstabReportWithPercentageMeasure test = new CrosstabReportWithPercentageMeasure();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

