/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.crosstab;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.CrosstabBuilder;
import ar.com.fdvs.dj.domain.builders.CrosstabColumnBuilder;
import ar.com.fdvs.dj.domain.builders.CrosstabRowBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import ar.com.fdvs.dj.test.TestRepositoryProducts;
import ar.com.fdvs.dj.util.SortUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperDesignViewer;
import net.sf.jasperreports.view.JasperViewer;

public class CrosstabReportTest2
extends BaseDjReportTest {
    private Style totalHeader;
    private Style colAndRowHeaderStyle;
    private Style mainHeaderStyle;
    private Style totalStyle;
    private Style measureStyle;
    private Style titleStyle;

    public DynamicReport buildReport() throws Exception {
        this.initStyles();
        FastReportBuilder drb = new FastReportBuilder();
        drb.setTitle("November 2006 sales report").setSubtitle("This report was generated at " + new Date()).setPageSizeAndOrientation(Page.Page_A4_Landscape()).setPrintColumnNames(false).setUseFullPageWidth(true).setDefaultStyles(this.titleStyle, null, null, null);
        DJCrosstab djcross = this.createCrosstab();
        drb.addHeaderCrosstab(djcross);
        DynamicReport dr = drb.build();
        this.params.put("sr", SortUtils.sortCollection((Collection)TestRepositoryProducts.getDummyCollection(), (DJCrosstab)djcross));
        return dr;
    }

    private DJCrosstab createCrosstab() {
        CrosstabBuilder cb = new CrosstabBuilder();
        cb.setHeight(200).setWidth(500).setHeaderStyle(this.mainHeaderStyle).setDatasource("sr", 0, 0).setUseFullWidth(true).setColorScheme(4).setAutomaticTitle(true).setCellBorder(Border.THIN());
        cb.addMeasure("amount", Float.class.getName(), DJCalculation.SUM, "Amount", this.measureStyle);
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty("productLine", String.class.getName()).setHeaderWidth(100).setHeight(20).setTitle("Product Line").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addRow(row);
        row = new CrosstabRowBuilder().setProperty("item", String.class.getName()).setHeaderWidth(100).setHeight(20).setTitle("Item").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addRow(row);
        row = new CrosstabRowBuilder().setProperty("id", Long.class.getName()).setHeaderWidth(100).setHeight(30).setTitle("ID").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addRow(row);
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty("state", String.class.getName()).setHeaderHeight(60).setWidth(80).setTitle("State").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addColumn(col);
        col = new CrosstabColumnBuilder().setProperty("branch", String.class.getName()).setHeaderHeight(30).setWidth(70).setShowTotals(true).setTitle("Branch").setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addColumn(col);
        return cb.build();
    }

    private void initStyles() {
        this.titleStyle = new StyleBuilder(false).setFont(Font.ARIAL_BIG_BOLD).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.MIDDLE).setTransparency(Transparency.OPAQUE).setBorderBottom(Border.PEN_2_POINT()).build();
        this.totalHeader = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_MEDIUM_BOLD).setTextColor(Color.BLUE).build();
        this.colAndRowHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.TOP).setFont(Font.ARIAL_MEDIUM_BOLD).build();
        this.mainHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_BIG_BOLD).setTextColor(Color.BLACK).build();
        this.totalStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM_BOLD).build();
        this.measureStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM).build();
    }

    public static void main(String[] args) throws Exception {
        CrosstabReportTest2 test = new CrosstabReportTest2();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
        JasperDesignViewer.viewReportDesign((JRReport)test.jr);
    }
}

