/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportExporter {
    private static final Log logger = LogFactory.getLog(ReportExporter.class);

    public static void exportReport(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        logger.debug((Object)("Exporing report to: " + path));
        JRPdfExporter exporter = new JRPdfExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fos);
        exporter.exportReport();
        logger.debug((Object)("Report exported: " + path));
    }

    public static void exportReportXls(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        JRXlsExporter exporter = new JRXlsExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fos);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)Boolean.FALSE);
        exporter.exportReport();
        logger.debug((Object)("XLS Report exported: " + path));
    }

    public static void exportReportHtml(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        JRHtmlExporter exporter = new JRHtmlExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fos);
        exporter.exportReport();
        logger.debug((Object)("HTML Report exported: " + path));
    }

    public static void exportReportPlainXls(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        JExcelApiExporter exporter = new JExcelApiExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fos);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.exportReport();
        logger.debug((Object)("Report exported: " + path));
    }
}

