/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import ar.com.fdvs.dj.test.domain.db.Customer;
import ar.com.fdvs.dj.test.hibernate.HibernateUtil;
import ar.com.fdvs.dj.test.hibernate.TestSchema;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import org.hibernate.Session;

public class HQLReportTest
extends BaseDjReportTest {
    private Session hsession;

    public DynamicReport buildReport() throws Exception {
        Style groupStyle = new StyleBuilder(false).setFont(new Font(18, "Verdana", true)).build();
        FastReportBuilder drb = new FastReportBuilder();
        drb.addColumn("City", "city", String.class.getName(), 50, groupStyle).addColumn("Last Name", "lastName", String.class.getName(), 50).addColumn("First Name", "firstName", String.class.getName(), 30).addColumn("Id", "id", Long.class.getName(), 30).addColumn("Street", "street", String.class.getName(), 50).addGroups(1, GroupLayout.VALUE_IN_HEADER).setTitle("Customers").setSubtitle("Order by city and last name").setQuery("from Customer order by city, lastName", "hql").setTemplateFile("templates/TemplateReportTest.jrxml").setUseFullPageWidth(true);
        DynamicReport dr = drb.build();
        this.hsession = HibernateUtil.getSession();
        this.params.put("HIBERNATE_SESSION", this.hsession);
        return dr;
    }

    protected JRDataSource getDataSource() {
        return null;
    }

    public static void main(String[] args) throws Exception {
        TestSchema.buildConfiguration();
        HQLReportTest test = new HQLReportTest();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }

    public void testHibernate() {
        TestSchema.buildConfiguration();
        Session s = HibernateUtil.getSession();
        List l = s.createQuery("from Customer order by lastName").list();
        for (Customer cust : l) {
            log.debug((Object)(cust.getFirstName() + ", " + cust.getLastName()));
        }
    }
}

