/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.test.ReportExporter;
import ar.com.fdvs.dj.test.TestRepositoryProducts;
import ar.com.fdvs.dj.util.SortUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseDjReportTest
extends TestCase {
    protected static final Log log = LogFactory.getLog(BaseDjReportTest.class);
    protected JasperPrint jp;
    protected JasperReport jr;
    protected Map params = new HashMap();
    protected DynamicReport dr;

    public Map getParams() {
        return this.params;
    }

    public abstract DynamicReport buildReport() throws Exception;

    public void testReport() throws Exception {
        this.dr = this.buildReport();
        JRDataSource ds = this.getDataSource();
        this.jr = DynamicJasperHelper.generateJasperReport((DynamicReport)this.dr, (LayoutManager)this.getLayoutManager(), (Map)this.params);
        log.debug((Object)"Filling the report");
        this.jp = ds != null ? JasperFillManager.fillReport((JasperReport)this.jr, (Map)this.params, (JRDataSource)ds) : JasperFillManager.fillReport((JasperReport)this.jr, (Map)this.params);
        log.debug((Object)"Filling done!");
        log.debug((Object)"Exporting the report (pdf, xls, etc)");
        this.exportReport();
        log.debug((Object)"test finished");
    }

    protected LayoutManager getLayoutManager() {
        return new ClassicLayoutManager();
    }

    protected void exportReport() throws Exception {
        ReportExporter.exportReport(this.jp, System.getProperty("user.dir") + "/target/reports/" + ((Object)((Object)this)).getClass().getName() + ".pdf");
        this.exportToJRXML();
    }

    protected void exportToJRXML() throws Exception {
        if (this.jr != null) {
            DynamicJasperHelper.generateJRXML((JasperReport)this.jr, (String)"UTF-8", (String)(System.getProperty("user.dir") + "/target/reports/" + ((Object)((Object)this)).getClass().getName() + ".jrxml"));
        } else {
            DynamicJasperHelper.generateJRXML((DynamicReport)this.dr, (LayoutManager)this.getLayoutManager(), (Map)this.params, (String)"UTF-8", (String)(System.getProperty("user.dir") + "/target/reports/" + ((Object)((Object)this)).getClass().getName() + ".jrxml"));
        }
    }

    protected void exportToHTML() throws Exception {
        ReportExporter.exportReportHtml(this.jp, System.getProperty("user.dir") + "/target/reports/" + ((Object)((Object)this)).getClass().getName() + ".html");
    }

    protected JRDataSource getDataSource() {
        List dummyCollection = TestRepositoryProducts.getDummyCollection();
        dummyCollection = SortUtils.sortCollection((Collection)dummyCollection, (List)this.dr.getColumns());
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource((Collection)dummyCollection);
        return ds;
    }

    public Collection getDummyCollectionSorted(List columnlist) {
        List dummyCollection = TestRepositoryProducts.getDummyCollection();
        return SortUtils.sortCollection((Collection)dummyCollection, (List)columnlist);
    }

    public DynamicReport getDynamicReport() {
        return this.dr;
    }

    public static Connection createSQLConnection() throws Exception {
        Connection con = null;
        Class.forName("org.hsqldb.jdbcDriver");
        con = DriverManager.getConnection("jdbc:hsqldb:file:target/test-classes/hsql/test_dj_db", "sa", "");
        return con;
    }
}

