/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnsGroupVariablesRegistrationManager
extends AbstractEntityRegistrationManager {
    private static final Log log = LogFactory.getLog((Class)ColumnsGroupVariablesRegistrationManager.class);
    private String type;
    private String columnToGroupByProperty;

    public ColumnsGroupVariablesRegistrationManager(String type, String columnToGroupByProperty, DynamicJasperDesign jd, DynamicReport dr) {
        super(jd, dr);
        this.type = type;
        this.columnToGroupByProperty = columnToGroupByProperty;
    }

    protected void registerEntity(Entity entity) {
        log.debug((Object)"registering group variable...");
        DJGroupVariable columnsGroupVariable = (DJGroupVariable)entity;
        try {
            JRDesignVariable jrVariable = (JRDesignVariable)this.transformEntity(entity);
            this.getDjd().addVariable(jrVariable);
            this.registerValueFormatter(columnsGroupVariable, jrVariable.getName());
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage());
        }
    }

    protected void registerValueFormatter(DJGroupVariable djVariable, String variableName) {
        if (djVariable.getValueFormatter() == null) {
            return;
        }
        JRDesignParameter dparam = new JRDesignParameter();
        dparam.setName(variableName + "_vf");
        dparam.setValueClassName(DJValueFormatter.class.getName());
        log.debug((Object)("Registering value formatter parameter for property " + dparam.getName()));
        try {
            this.getDjd().addParameter((JRParameter)dparam);
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage());
        }
        this.getDjd().getParametersWithValues().put(dparam.getName(), djVariable.getValueFormatter());
    }

    protected Object transformEntity(Entity entity) {
        log.debug((Object)"transforming group variable...");
        DJGroupVariable columnsGroupVariable = (DJGroupVariable)entity;
        AbstractColumn col = columnsGroupVariable.getColumnToApplyOperation();
        DJCalculation op = columnsGroupVariable.getOperation();
        JRDesignExpression expression = new JRDesignExpression();
        List groupsList = this.getDjd().getGroupsList();
        JRDesignGroup registeredGroup = (JRDesignGroup)groupsList.get(groupsList.size() - 1);
        if (col instanceof ExpressionColumn && ((ExpressionColumn)col).getExpressionForCalculation() != null) {
            ExpressionColumn expcol = (ExpressionColumn)col;
            expression.setText(expcol.getTextForExpressionForCalculartion());
            expression.setValueClassName(expcol.getExpressionForCalculation().getClassName());
        } else {
            expression.setText(col.getTextForExpression());
            expression.setValueClassName(col.getValueClassNameForExpression());
        }
        String variableName = col.getGroupVariableName(this.type, this.columnToGroupByProperty);
        JRDesignVariable variable = new JRDesignVariable();
        variable.setExpression((JRExpression)expression);
        variable.setCalculation(columnsGroupVariable.getOperation().getValue());
        variable.setName(variableName);
        variable.setResetType((byte)4);
        variable.setResetGroup((JRGroup)registeredGroup);
        String valueClassName = col.getVariableClassName(op);
        String initialExpression = col.getInitialExpression(op);
        variable.setValueClassName(valueClassName);
        JRDesignExpression initialExp = new JRDesignExpression();
        initialExp.setText(initialExpression);
        initialExp.setValueClassName(valueClassName);
        variable.setInitialValueExpression((JRExpression)initialExp);
        return variable;
    }
}

