/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.DJJRDesignHelper;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.ColumnRegistrationManager;
import ar.com.fdvs.dj.core.registration.DJGroupRegistrationManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.Parameter;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.util.DJCompilerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicJasperHelper {
    private static final Log log = LogFactory.getLog((Class)DynamicJasperHelper.class);
    public static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DJ_RESOURCE_BUNDLE = "dj-messages";

    private static final void registerEntities(DynamicJasperDesign jd, DynamicReport dr) {
        Locale locale;
        new ColumnRegistrationManager(jd, dr).registerEntities(dr.getColumns());
        new DJGroupRegistrationManager(jd, dr).registerEntities(dr.getColumnsGroups());
        DynamicJasperHelper.registerOtherFields(jd, dr.getFields());
        Locale locale2 = locale = dr.getReportLocale() == null ? Locale.getDefault() : dr.getReportLocale();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requested Locale = " + dr.getReportLocale() + ", Locale to use: " + locale));
        }
        ResourceBundle messages = null;
        if (dr.getResourceBundle() != null) {
            try {
                messages = ResourceBundle.getBundle(dr.getResourceBundle(), locale);
            }
            catch (MissingResourceException e) {
                log.warn((Object)(e.getMessage() + ", usign defaut (dj-messages)"));
            }
        }
        if (messages == null) {
            try {
                messages = ResourceBundle.getBundle(DJ_RESOURCE_BUNDLE, locale);
            }
            catch (MissingResourceException e) {
                log.warn((Object)(e.getMessage() + ", usign defaut (dj-messages)"));
                try {
                    messages = ResourceBundle.getBundle(DJ_RESOURCE_BUNDLE, Locale.ENGLISH);
                }
                catch (MissingResourceException e2) {
                    log.error((Object)("Default messajes not found: dj-messages, " + e2.getMessage()), (Throwable)e2);
                    throw new DJException("Default messajes file not found: dj-messagesen.properties", e2);
                }
            }
        }
        jd.getParametersWithValues().put("REPORT_RESOURCE_BUNDLE", messages);
        jd.getParametersWithValues().put("REPORT_LOCALE", locale);
    }

    private static void registerOtherFields(DynamicJasperDesign jd, List fields) {
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            ColumnProperty element = (ColumnProperty)iter.next();
            JRDesignField field = new JRDesignField();
            field.setValueClassName(element.getValueClassName());
            field.setName(element.getProperty());
            try {
                jd.addField((JRField)field);
            }
            catch (JRException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static DynamicJasperDesign generateJasperDesign(DynamicReport dr) throws CoreException {
        DynamicJasperDesign jd = null;
        try {
            if (dr.getTemplateFileName() != null) {
                log.info((Object)("loading template file: " + dr.getTemplateFileName()));
                log.info((Object)"Attemping to find the file directly in the file system...");
                File file = new File(dr.getTemplateFileName());
                if (file.exists()) {
                    JasperDesign jdesign = JRXmlLoader.load((File)file);
                    jd = DJJRDesignHelper.downCast(jdesign, dr);
                } else {
                    log.info((Object)"Not found: Attemping to find the file in the classpath...");
                    URL url = DynamicJasperHelper.class.getClassLoader().getResource(dr.getTemplateFileName());
                    JasperDesign jdesign = JRXmlLoader.load((InputStream)url.openStream());
                    jd = DJJRDesignHelper.downCast(jdesign, dr);
                }
                DJJRDesignHelper.populateReportOptionsFromDesign(jd, dr);
            } else {
                jd = DJJRDesignHelper.getNewDesign(dr);
            }
            jd.setScriptletClass(DJDefaultScriptlet.class.getName());
            DynamicJasperHelper.registerParameters(jd, dr);
        }
        catch (JRException e) {
            throw new CoreException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage(), e);
        }
        return jd;
    }

    protected static void registerParameters(DynamicJasperDesign jd, DynamicReport dr) {
        Iterator iterator = dr.getParameters().iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            JRDesignParameter jrparam = new JRDesignParameter();
            jrparam.setName(param.getName());
            jrparam.setValueClassName(param.getClassName());
            try {
                jd.addParameter((JRParameter)jrparam);
            }
            catch (JRException e) {
                throw new CoreException(e.getMessage(), e);
            }
        }
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, JRDataSource ds) throws JRException {
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, ds, new HashMap());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Collection collection) throws JRException {
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collection);
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, (JRDataSource)ds, new HashMap());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, ResultSet resultSet) throws JRException {
        JRResultSetDataSource ds = new JRResultSetDataSource(resultSet);
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, (JRDataSource)ds, new HashMap());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, JRDataSource ds, Map _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperPrint jp = null;
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        jp = JasperFillManager.fillReport((JasperReport)jr, (Map)_parameters, (JRDataSource)ds);
        return jp;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Connection con, Map _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperPrint jp = null;
        if (_parameters == null) {
            _parameters = new HashMap();
        }
        DynamicJasperHelper.visitSubreports(dr, _parameters);
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap params = new HashMap();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.", (String)DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        jp = JasperFillManager.fillReport((JasperReport)jr, params, (Connection)con);
        return jp;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Map _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperPrint jp = null;
        if (_parameters == null) {
            _parameters = new HashMap();
        }
        DynamicJasperHelper.visitSubreports(dr, _parameters);
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap params = new HashMap();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.", (String)DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        jp = JasperFillManager.fillReport((JasperReport)jr, params);
        return jp;
    }

    public static String generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        return JRXmlWriter.writeReport((JRReport)jr, (String)xmlEncoding);
    }

    public static void generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding, OutputStream outputStream) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        JRXmlWriter.writeReport((JRReport)jr, (OutputStream)outputStream, (String)xmlEncoding);
    }

    public static void generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding, String filename) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        JRXmlWriter.writeReport((JRReport)jr, (String)filename, (String)xmlEncoding);
    }

    protected static void compileOrLoadSubreports(DynamicReport dr, Map _parameters) throws JRException {
        Iterator iterator = dr.getColumnsGroups().iterator();
        while (iterator.hasNext()) {
            JasperReport jp;
            Subreport subreport;
            DJGroup group = (DJGroup)iterator.next();
            Iterator iterator2 = group.getHeaderSubreports().iterator();
            while (iterator2.hasNext()) {
                subreport = (Subreport)iterator2.next();
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.compileOrLoadSubreports(subreport.getDynamicReport(), _parameters);
                jp = DynamicJasperHelper.generateJasperReport(subreport.getDynamicReport(), subreport.getLayoutManager(), _parameters);
                _parameters.put(jp.toString(), jp);
                subreport.setReport(jp);
            }
            iterator2 = group.getFooterSubreports().iterator();
            while (iterator2.hasNext()) {
                subreport = (Subreport)iterator2.next();
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.compileOrLoadSubreports(subreport.getDynamicReport(), _parameters);
                jp = DynamicJasperHelper.generateJasperReport(subreport.getDynamicReport(), subreport.getLayoutManager(), _parameters);
                _parameters.put(jp.toString(), jp);
                subreport.setReport(jp);
            }
        }
    }

    public static void registerParams(DynamicJasperDesign jd, Map _parameters) {
        Iterator iterator = _parameters.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!(key instanceof String)) continue;
            try {
                if (jd.getParametersMap().get(key) != null) {
                    log.warn((Object)("Parameter \"" + key + "\" already registered, skipping this one."));
                    continue;
                }
                JRDesignParameter parameter = new JRDesignParameter();
                Object value = _parameters.get(key);
                if (value == null) continue;
                Class<?> clazz = value.getClass().getComponentType();
                if (clazz == null) {
                    clazz = value.getClass();
                }
                parameter.setValueClass(clazz);
                parameter.setName((String)key);
                jd.addParameter((JRParameter)parameter);
            }
            catch (JRException e) {}
        }
    }

    public static final JasperReport generateJasperReport(DynamicReport dr, LayoutManager layoutManager, Map generatedParams) throws JRException {
        log.info((Object)"generating JasperReport");
        JasperReport jr = null;
        if (generatedParams == null) {
            generatedParams = new HashMap();
        }
        DynamicJasperHelper.visitSubreports(dr, generatedParams);
        DynamicJasperHelper.compileOrLoadSubreports(dr, generatedParams);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        DynamicJasperHelper.registerEntities(jd, dr);
        DynamicJasperHelper.registerParams(jd, generatedParams);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.", (String)"ar.com.fdvs.dj.util.DJJRJdtCompiler");
        jr = JasperCompileManager.compileReport((JasperDesign)jd);
        generatedParams.putAll(jd.getParametersWithValues());
        return jr;
    }

    protected static void visitSubreports(DynamicReport dr, Map _parameters) throws JRException {
        Iterator iterator = dr.getColumnsGroups().iterator();
        while (iterator.hasNext()) {
            Subreport subreport;
            DJGroup group = (DJGroup)iterator.next();
            Iterator iterator2 = group.getHeaderSubreports().iterator();
            while (iterator2.hasNext()) {
                subreport = (Subreport)iterator2.next();
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.visitSubreport(dr, subreport, _parameters);
                DynamicJasperHelper.visitSubreports(subreport.getDynamicReport(), _parameters);
            }
            iterator2 = group.getFooterSubreports().iterator();
            while (iterator2.hasNext()) {
                subreport = (Subreport)iterator2.next();
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.visitSubreport(dr, subreport, _parameters);
                DynamicJasperHelper.visitSubreports(subreport.getDynamicReport(), _parameters);
            }
        }
    }

    protected static void visitSubreport(DynamicReport parentDr, Subreport subreport, Map _parameters) {
        DynamicReport childDr = subreport.getDynamicReport();
        if (subreport.isFitToParentPrintableArea()) {
            childDr.getOptions().setPage(parentDr.getOptions().getPage());
            childDr.getOptions().setLeftMargin(parentDr.getOptions().getLeftMargin());
            childDr.getOptions().setRightMargin(parentDr.getOptions().getRightMargin());
        }
    }
}

