/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.struts2;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.output.FormatInfoRegistry;
import ar.com.fdvs.dj.output.ReportWriter;
import ar.com.fdvs.dj.output.ReportWriterFactory;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.jasperreports.JasperReportsResult;
import org.apache.struts2.views.jasperreports.ValueStackShadowMap;

public class DJStruts2Result
extends JasperReportsResult {
    private static final long serialVersionUID = -5135527859073133975L;
    private static final Log LOG = LogFactory.getLog((Class)DJStruts2Result.class);
    public static final String LAYOUT_CLASSIC = "classic";
    public static final String LAYOUT_LIST = "list";
    protected String dynamicReport;
    protected String documentFormat;
    protected String layoutManager;
    protected String exportParams;
    protected String parameters;
    private boolean parse;

    public void setDynamicReport(String _dynamicReport) {
        this.dynamicReport = _dynamicReport;
    }

    public void setParse(boolean _parse) {
        super.setParse(_parse);
        this.parse = _parse;
    }

    protected void doExecute(String _finalLocation, ActionInvocation _invocation) throws Exception {
        this.checkParams();
        this.documentFormat = this.getFormat(_invocation);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JasperReport for dynamicReport, format = " + this.documentFormat));
        }
        Map actionParametersMap = this.getParametersMap(_invocation);
        JRDataSource ds = this.buildJRDataSource(_invocation.getStack().findValue(this.dataSource));
        HttpServletRequest request = (HttpServletRequest)_invocation.getInvocationContext().get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)_invocation.getInvocationContext().get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        if ("contype".equals(request.getHeader("User-Agent"))) {
            this.handleConTypeRequest(response);
        } else {
            ValueStackShadowMap parameters = new ValueStackShadowMap(_invocation.getStack());
            parameters.putAll(actionParametersMap);
            parameters.put((Object)"REPORT_LOCALE", (Object)_invocation.getInvocationContext().getLocale());
            LayoutManager layoutManagerObj = this.getLayOutManagerObj(_invocation);
            JasperPrint jasperPrint = null;
            jasperPrint = ds != null ? DynamicJasperHelper.generateJasperPrint(this.getDynamicReport(_invocation), layoutManagerObj, ds, (Map)parameters) : DynamicJasperHelper.generateJasperPrint(this.getDynamicReport(_invocation), layoutManagerObj, (Map)parameters);
            this.writeReponse(request, response, jasperPrint, _invocation);
        }
    }

    protected Map getParametersMap(ActionInvocation _invocation) {
        HashMap map = (HashMap)_invocation.getStack().findValue(this.parameters);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    protected JRDataSource buildJRDataSource(Object dsCandidate) {
        if (dsCandidate == null) {
            return null;
        }
        if (dsCandidate instanceof JRDataSource) {
            return (JRDataSource)dsCandidate;
        }
        if (dsCandidate instanceof Collection) {
            return new JRBeanCollectionDataSource((Collection)dsCandidate);
        }
        if (dsCandidate instanceof ResultSet) {
            return new JRResultSetDataSource((ResultSet)dsCandidate);
        }
        if (dsCandidate.getClass().isArray()) {
            return new JRBeanArrayDataSource((Object[])dsCandidate);
        }
        throw new DJException("class " + dsCandidate.getClass().getName() + " is not supported " + "from the DynamicJasper WebWorK result type. Provide a JRDataSource implementation instead");
    }

    protected LayoutManager getLayOutManagerObj(ActionInvocation _invocation) {
        if (this.layoutManager == null || "".equals(this.layoutManager)) {
            LOG.warn((Object)"No valid LayoutManager, using ClassicLayoutManager");
            return new ClassicLayoutManager();
        }
        String los = this.conditionalParse(this.layoutManager, _invocation);
        if (los instanceof LayoutManager) {
            return (LayoutManager)((Object)los);
        }
        LayoutManager lo = null;
        if (los instanceof String) {
            if (LAYOUT_CLASSIC.equalsIgnoreCase(los)) {
                lo = new ClassicLayoutManager();
            } else if (LAYOUT_LIST.equalsIgnoreCase(los)) {
                lo = new ListLayoutManager();
            } else {
                try {
                    lo = (LayoutManager)Class.forName(los).newInstance();
                }
                catch (Exception e) {
                    LOG.warn((Object)("No valid LayoutManager: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return lo;
    }

    protected void handleConTypeRequest(HttpServletResponse _response) throws ServletException {
        try {
            _response.setContentType(FormatInfoRegistry.getInstance().getContentType(this.documentFormat));
            _response.setContentLength(0);
            _response.getOutputStream().close();
        }
        catch (IOException ex) {
            LOG.error((Object)"Error writing report output", (Throwable)ex);
            throw new ServletException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void checkParams() {
        if (this.dynamicReport == null) {
            String message = "No dynamicReport specified...";
            LOG.error((Object)"No dynamicReport specified...");
            throw new StrutsException("No dynamicReport specified...");
        }
        if (this.dataSource == null) {
            String message = "No dataSource specified...";
            LOG.debug((Object)"No dataSource specified...");
        }
    }

    protected void setResponseHeaders(HttpServletResponse _response, ActionInvocation _invocation) {
        if (this.contentDisposition != null || this.documentName != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getContentDisposition(_invocation));
            if (this.documentName != null) {
                buffer.append("; filename=");
                buffer.append(this.getDocumentName(_invocation));
                buffer.append(".");
                buffer.append(this.documentFormat.toLowerCase());
            }
            _response.setHeader("Content-disposition", buffer.toString());
        }
        _response.setContentType(FormatInfoRegistry.getInstance().getContentType(this.documentFormat));
    }

    protected void writeReponse(HttpServletRequest _request, HttpServletResponse _response, JasperPrint _jasperPrint, ActionInvocation _invocation) throws JRException, IOException {
        this.setResponseHeaders(_response, _invocation);
        HashMap<JRHtmlExporterParameter, String> parameters = new HashMap<JRHtmlExporterParameter, String>(this.getExportParams(_invocation));
        parameters.put(JRHtmlExporterParameter.IMAGES_URI, _request.getContextPath() + this.imageServletUrl);
        ReportWriter reportWriter = ReportWriterFactory.getInstance().getReportWriter(_jasperPrint, this.documentFormat, parameters);
        if ("HTML".equals(this.documentFormat)) {
            HashMap imagesMap = new HashMap();
            JRExporter exporter = reportWriter.getExporter();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(_request.getContextPath() + this.imageServletUrl));
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)_jasperPrint);
            _request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)_jasperPrint);
        }
        reportWriter.writeTo(_response);
    }

    protected Map getExportParams(ActionInvocation _invocation) {
        HashMap params = (HashMap)this.conditionalParse(this.exportParams, _invocation, Map.class);
        if (params == null) {
            params = new HashMap();
        }
        return params;
    }

    protected DynamicReport getDynamicReport(ActionInvocation _invocation) {
        return (DynamicReport)_invocation.getStack().findValue(this.dynamicReport);
    }

    protected String getFormat(ActionInvocation _invocation) {
        String parsedFormat = this.conditionalParse(this.format == null ? "PDF" : this.format, _invocation);
        return TextUtils.stringSet((String)parsedFormat) ? parsedFormat : "PDF";
    }

    protected String getDocumentName(ActionInvocation _invocation) {
        return this.conditionalParse(this.documentName, _invocation);
    }

    protected String getContentDisposition(ActionInvocation _invocation) {
        String parsedContentDisposition = this.conditionalParse(this.contentDisposition, _invocation);
        return parsedContentDisposition == null ? "inline" : parsedContentDisposition;
    }

    protected Object conditionalParse(String _param, ActionInvocation _invocation, Class _type) {
        if (this.parse && _param != null && _invocation != null) {
            return TextParseUtil.translateVariables((char)'$', (String)_param, (ValueStack)_invocation.getStack(), (Class)_type, null);
        }
        return _param;
    }

    public String getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(String layoutManager) {
        this.layoutManager = layoutManager;
    }

    public String getExportParams() {
        return this.exportParams;
    }

    public void setExportParams(String exportParams) {
        this.exportParams = exportParams;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }
}

