/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.domain.DJChart;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class DataSetFactory {
    public static JRDesignChartDataset getDataset(DJChart djchart, JRDesignGroup group, JRDesignGroup parentGroup, List vars) {
        JRDesignChartDataset dataSet = null;
        byte chartType = djchart.getType();
        if (chartType == 9) {
            dataSet = DataSetFactory.createPieDataset(group, parentGroup, vars, djchart);
        } else if (chartType == 3) {
            dataSet = DataSetFactory.createBarDataset(group, parentGroup, vars, djchart);
        }
        if (dataSet == null) {
            throw new DJException("Error creating dataset for chart, no valid dataset type.");
        }
        return dataSet;
    }

    protected static JRDesignChartDataset createLineDataset(JRDesignGroup group, JRDesignGroup parentGroup, List vars, DJChart djchart) {
        JRDesignCategoryDataset data = new JRDesignCategoryDataset(null);
        JRDesignCategorySeries serie = new JRDesignCategorySeries();
        JRDesignVariable var = (JRDesignVariable)vars.get(0);
        JRDesignVariable var1 = (JRDesignVariable)vars.get(0);
        if (vars.size() > 1) {
            var1 = (JRDesignVariable)vars.get(1);
        }
        JRDesignExpression varExp = DataSetFactory.getExpressionFromVariable(var);
        JRExpression varExp1 = var1.getExpression();
        serie.setValueExpression((JRExpression)varExp);
        JRExpression exp2 = group.getExpression();
        JRDesignExpression exp3 = new JRDesignExpression();
        int index = vars.indexOf(var);
        AbstractColumn col = (AbstractColumn)djchart.getColumns().get(index);
        exp3.setText("\"" + col.getTitle() + "\"");
        exp3.setValueClass(String.class);
        serie.setCategoryExpression(exp2);
        serie.setLabelExpression(exp2);
        serie.setSeriesExpression(varExp1);
        data.addCategorySeries((JRCategorySeries)serie);
        DataSetFactory.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    protected static JRDesignChartDataset createBarDataset(JRDesignGroup group, JRDesignGroup parentGroup, List vars, DJChart djchart) {
        JRDesignCategoryDataset data = new JRDesignCategoryDataset(null);
        Iterator iterator = vars.iterator();
        while (iterator.hasNext()) {
            JRDesignCategorySeries serie = new JRDesignCategorySeries();
            JRDesignVariable var = (JRDesignVariable)iterator.next();
            JRDesignExpression varExp = DataSetFactory.getExpressionFromVariable(var);
            serie.setValueExpression((JRExpression)varExp);
            JRExpression exp2 = group.getExpression();
            JRDesignExpression exp3 = new JRDesignExpression();
            int index = vars.indexOf(var);
            AbstractColumn col = (AbstractColumn)djchart.getColumns().get(index);
            exp3.setText("\"" + col.getTitle() + "\"");
            exp3.setValueClass(class$java$lang$String == null ? DataSetFactory.class$("java.lang.String") : class$java$lang$String);
            serie.setCategoryExpression((JRExpression)exp3);
            serie.setLabelExpression(exp2);
            serie.setSeriesExpression(exp2);
            data.addCategorySeries((JRCategorySeries)serie);
        }
        DataSetFactory.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    protected static JRDesignChartDataset createPieDataset(JRDesignGroup group, JRDesignGroup parentGroup, List vars, DJChart djchart) {
        JRDesignPieDataset data = new JRDesignPieDataset(null);
        Iterator iterator = vars.iterator();
        if (iterator.hasNext()) {
            JRDesignVariable var = (JRDesignVariable)iterator.next();
            JRDesignExpression expression = DataSetFactory.getExpressionFromVariable(var);
            data.setValueExpression((JRExpression)expression);
        }
        data.setKeyExpression(group.getExpression());
        DataSetFactory.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    private static JRDesignExpression getExpressionFromVariable(JRDesignVariable var) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("$V{" + var.getName() + "}");
        exp.setValueClass(var.getValueClass());
        return exp;
    }

    private static void setResetStyle(JRDesignChartDataset dataset, JRDesignGroup group, JRDesignGroup parentGroup) {
        dataset.setResetGroup((JRGroup)parentGroup);
        if (dataset.getResetGroup().equals(group)) {
            dataset.setResetType((byte)1);
        } else {
            dataset.setResetType((byte)4);
        }
    }
}

