/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.FontHelper;
import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.CommonExpressionsHelper;
import ar.com.fdvs.dj.core.layout.Dj2JrCrosstabBuilder;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.ImageBanner;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.GlobalGroupColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.LayoutUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassicLayoutManager
extends AbstractLayoutManager {
    protected static final String PAGE_BREAK_FOR_ = "pageBreak_for_";
    protected static final int SUBREPORT_DEFAULT_HEIGHT = 30;
    private static final Log log = LogFactory.getLog((Class)ClassicLayoutManager.class);
    protected static final String EXPRESSION_TRUE_WHEN_NOT_FIRST_PAGE = "new java.lang.Boolean(((Number)$V{PAGE_NUMBER}).doubleValue() != 1)";
    protected static final String EXPRESSION_TRUE_WHEN_FIRST_PAGE = "new java.lang.Boolean(((Number)$V{PAGE_NUMBER}).doubleValue() == 1)";
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JasperReport;

    protected void startLayout() {
        super.startLayout();
        this.generateTitleBand();
        this.generateHeaderBand();
        this.applyHeaderAutotexts();
        if (this.getReport().getColumnsGroups() != null) {
            this.layoutGroups();
        }
    }

    protected void applyHeaderAutotexts() {
        if (this.getReport().getAutoTexts() == null) {
            return;
        }
        JRDesignBand headerband = (JRDesignBand)this.getDesign().getPageHeader();
        if (headerband == null) {
            headerband = new JRDesignBand();
            this.getDesign().setPageHeader((JRBand)headerband);
        }
        ArrayList<HorizontalBandAlignment> positions = new ArrayList<HorizontalBandAlignment>();
        positions.add(HorizontalBandAlignment.LEFT);
        positions.add(HorizontalBandAlignment.CENTER);
        positions.add(HorizontalBandAlignment.RIGHT);
        ArrayList autotexts = new ArrayList(this.getReport().getAutoTexts());
        Collections.reverse(autotexts);
        int totalYoffset = this.findTotalOffset(positions, autotexts, (byte)1);
        LayoutUtils.moveBandsElemnts(totalYoffset, headerband);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            HorizontalBandAlignment currentAlignment = (HorizontalBandAlignment)iterator.next();
            int yOffset = 0;
            Iterator iter = this.getReport().getAutoTexts().iterator();
            while (iter.hasNext()) {
                AutoText text = (AutoText)iter.next();
                if (text.getPosition() != 1 || !text.getAlignment().equals(currentAlignment)) continue;
                CommonExpressionsHelper.add(yOffset, this.getDesign(), this.getReport(), headerband, text);
                yOffset += text.getHeight().intValue();
            }
        }
    }

    protected int findTotalOffset(ArrayList aligments, ArrayList autotexts, byte position) {
        int total = 0;
        Iterator iterator = aligments.iterator();
        while (iterator.hasNext()) {
            HorizontalBandAlignment currentAlignment = (HorizontalBandAlignment)iterator.next();
            int aux = 0;
            Iterator iter = this.getReport().getAutoTexts().iterator();
            while (iter.hasNext()) {
                AutoText autotext = (AutoText)iter.next();
                if (autotext.getPosition() != position || !currentAlignment.equals(autotext.getAlignment())) continue;
                aux += autotext.getHeight().intValue();
            }
            if (aux <= total) continue;
            total = aux;
        }
        return total;
    }

    protected void endLayout() {
        super.endLayout();
        this.applyBanners();
        this.applyFooterAutotexts();
        this.setBandsFinalHeight();
    }

    protected void applyFooterAutotexts() {
        if (this.getReport().getAutoTexts() == null) {
            return;
        }
        JRDesignBand footerband = (JRDesignBand)this.getDesign().getPageFooter();
        if (footerband == null) {
            footerband = new JRDesignBand();
            this.getDesign().setPageFooter((JRBand)footerband);
        }
        ArrayList<HorizontalBandAlignment> positions = new ArrayList<HorizontalBandAlignment>();
        positions.add(HorizontalBandAlignment.LEFT);
        positions.add(HorizontalBandAlignment.CENTER);
        positions.add(HorizontalBandAlignment.RIGHT);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            HorizontalBandAlignment currentAlignment = (HorizontalBandAlignment)iterator.next();
            int yOffset = 0;
            Iterator iter = this.getReport().getAutoTexts().iterator();
            while (iter.hasNext()) {
                AutoText autotext = (AutoText)iter.next();
                if (autotext.getPosition() != 0 || !autotext.getAlignment().equals(currentAlignment)) continue;
                CommonExpressionsHelper.add(yOffset, this.getDesign(), this.getReport(), footerband, autotext);
                yOffset += autotext.getHeight().intValue();
            }
        }
    }

    protected List getVisibleColumns() {
        ArrayList visibleColums = new ArrayList(this.getReport().getColumns());
        Iterator iterator = this.getReport().getColumnsGroups().iterator();
        while (iterator.hasNext()) {
            DJGroup group = (DJGroup)iterator.next();
            if (!group.getLayout().isHideColumn()) continue;
            visibleColums.remove(group.getColumnToGroupBy());
        }
        return visibleColums;
    }

    protected void applyBanners() {
        JRDesignBand title = (JRDesignBand)this.getDesign().getTitle();
        if (title == null && !this.getReport().getOptions().getFirstPageImageBanners().isEmpty()) {
            title = new JRDesignBand();
            this.getDesign().setTitle((JRBand)title);
        }
        this.applyImageBannersToBand(title, this.getReport().getOptions().getFirstPageImageBanners().values(), null);
        JRDesignBand pageHeader = (JRDesignBand)this.getDesign().getPageHeader();
        if (pageHeader == null && !this.getReport().getOptions().getImageBanners().isEmpty()) {
            pageHeader = new JRDesignBand();
            this.getDesign().setPageHeader((JRBand)pageHeader);
        }
        JRDesignExpression printWhenExpression = null;
        if (!this.getReport().getOptions().getFirstPageImageBanners().isEmpty()) {
            printWhenExpression = new JRDesignExpression();
            printWhenExpression.setValueClass(Boolean.class);
            printWhenExpression.setText(EXPRESSION_TRUE_WHEN_NOT_FIRST_PAGE);
        }
        this.applyImageBannersToBand(pageHeader, this.getReport().getOptions().getImageBanners().values(), printWhenExpression);
    }

    protected void applyImageBannersToBand(JRDesignBand band, Collection imageBanners, JRDesignExpression printWhenExpression) {
        ImageBanner imageBanner;
        int maxHeight = 0;
        Iterator iter = imageBanners.iterator();
        while (iter.hasNext()) {
            imageBanner = (ImageBanner)iter.next();
            if (imageBanner.getHeight() <= maxHeight) continue;
            maxHeight = imageBanner.getHeight();
        }
        if (band != null) {
            iter = band.getChildren().iterator();
            while (iter.hasNext()) {
                JRDesignElement element = (JRDesignElement)iter.next();
                element.setY(element.getY() + maxHeight);
            }
            iter = imageBanners.iterator();
            while (iter.hasNext()) {
                imageBanner = (ImageBanner)iter.next();
                String path = "\"" + imageBanner.getImagePath().replaceAll("\\\\", "/") + "\"";
                JRDesignImage image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
                JRDesignExpression imageExp = new JRDesignExpression();
                imageExp.setText(path);
                imageExp.setValueClass(class$java$lang$String == null ? ClassicLayoutManager.class$("java.lang.String") : class$java$lang$String);
                image.setExpression((JRExpression)imageExp);
                image.setHeight(imageBanner.getHeight());
                image.setWidth(imageBanner.getWidth());
                image.setPrintWhenExpression((JRExpression)printWhenExpression);
                image.setRemoveLineWhenBlank(true);
                if (imageBanner.getAlign() == 0) {
                    image.setX(0);
                } else if (imageBanner.getAlign() == 1) {
                    image.setX(this.getReport().getOptions().getPage().getWidth() - this.getReport().getOptions().getLeftMargin() - this.getReport().getOptions().getRightMargin() - imageBanner.getWidth());
                } else if (imageBanner.getAlign() == 2) {
                    int x = (this.getReport().getOptions().getPage().getWidth() - this.getReport().getOptions().getRightMargin() - this.getReport().getOptions().getLeftMargin() - imageBanner.getWidth()) / 2;
                    image.setX(this.getReport().getOptions().getLeftMargin() + x);
                }
                image.setY(0);
                band.addElement((JRDesignElement)image);
            }
            band.setHeight(band.getHeight() + maxHeight);
        }
    }

    protected void generateTitleBand() {
        log.debug((Object)"Generating title band...");
        JRDesignBand band = (JRDesignBand)this.getDesign().getPageHeader();
        int yOffset = 0;
        if (this.getReport().getTitle() == null) {
            return;
        }
        if (band != null && !this.getDesign().isTitleNewPage()) {
            yOffset = band.getHeight();
        } else {
            band = (JRDesignBand)this.getDesign().getTitle();
            if (band == null) {
                band = new JRDesignBand();
                this.getDesign().setTitle((JRBand)band);
            }
        }
        JRDesignExpression printWhenExpression = new JRDesignExpression();
        printWhenExpression.setValueClass(Boolean.class);
        printWhenExpression.setText(EXPRESSION_TRUE_WHEN_FIRST_PAGE);
        JRDesignTextField title = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("\"" + this.getReport().getTitle() + "\"");
        exp.setValueClass(String.class);
        title.setExpression((JRExpression)exp);
        title.setWidth(this.getReport().getOptions().getPrintableWidth());
        title.setHeight(this.getReport().getOptions().getTitleHeight().intValue());
        title.setY(yOffset);
        title.setPrintWhenExpression((JRExpression)printWhenExpression);
        title.setRemoveLineWhenBlank(true);
        this.applyStyleToElement(this.getReport().getTitleStyle(), (JRDesignElement)title);
        title.setStretchType((byte)0);
        band.addElement((JRDesignElement)title);
        JRDesignTextField subtitle = new JRDesignTextField();
        if (this.getReport().getSubtitle() != null) {
            JRDesignExpression exp2 = new JRDesignExpression();
            exp2.setText("\"" + this.getReport().getSubtitle() + "\"");
            exp2.setValueClass(String.class);
            subtitle.setExpression((JRExpression)exp2);
            subtitle.setWidth(this.getReport().getOptions().getPrintableWidth());
            subtitle.setHeight(this.getReport().getOptions().getSubtitleHeight().intValue());
            subtitle.setY(title.getY() + title.getHeight());
            subtitle.setPrintWhenExpression((JRExpression)printWhenExpression);
            subtitle.setRemoveLineWhenBlank(true);
            this.applyStyleToElement(this.getReport().getSubtitleStyle(), (JRDesignElement)subtitle);
            title.setStretchType((byte)0);
            band.addElement((JRDesignElement)subtitle);
        }
    }

    protected void layoutGroups() {
        log.debug((Object)"Starting groups layout...");
        boolean i = false;
        Iterator iter = this.getReport().getColumnsGroups().iterator();
        while (iter.hasNext()) {
            DJGroup columnsGroup = (DJGroup)iter.next();
            JRDesignGroup jgroup = this.getJRGroupFromDJGroup(columnsGroup);
            jgroup.setStartNewPage(columnsGroup.getStartInNewPage().booleanValue());
            jgroup.setStartNewColumn(columnsGroup.getStartInNewColumn().booleanValue());
            JRDesignBand header = (JRDesignBand)jgroup.getGroupHeader();
            JRDesignBand footer = (JRDesignBand)jgroup.getGroupFooter();
            header.setHeight(columnsGroup.getHeaderHeight().intValue());
            footer.setHeight(columnsGroup.getFooterHeight().intValue());
            header.setSplitAllowed(columnsGroup.isAllowHeaderSplit());
            footer.setSplitAllowed(columnsGroup.isAllowFooterSplit());
            if (columnsGroup.getLayout().isPrintHeaders()) {
                boolean found = false;
                boolean skipPreviousGroupHeaders = false;
                int groupIdx = this.getReport().getColumnsGroups().indexOf(columnsGroup);
                if (groupIdx > 0) {
                    DJGroup prevG = (DJGroup)this.getReport().getColumnsGroups().get(groupIdx - 1);
                    skipPreviousGroupHeaders = !prevG.getLayout().isShowValueForEachRow();
                }
                Iterator iterator = this.getVisibleColumns().iterator();
                while (iterator.hasNext()) {
                    AbstractColumn col = (AbstractColumn)iterator.next();
                    if (col.equals(columnsGroup.getColumnToGroupBy())) {
                        found = true;
                    }
                    if (!found && skipPreviousGroupHeaders) continue;
                    JRDesignTextField designTextField = this.createColumnNameTextField(columnsGroup, col);
                    designTextField.setPositionType((byte)1);
                    designTextField.setStretchType((byte)0);
                    header.addElement((JRDesignElement)designTextField);
                }
            }
            this.layoutGroupVariables(columnsGroup, jgroup);
            this.layoutGroupSubreports(columnsGroup, jgroup);
            this.layoutGroupCrosstabs(columnsGroup, jgroup);
        }
    }

    protected void layoutGroupCrosstabs(DJGroup columnsGroup, JRDesignGroup jgroup) {
        JRDesignBand band;
        JRDesignCrosstab crosst;
        Dj2JrCrosstabBuilder djcb;
        DJCrosstab djcross;
        Iterator iterator = columnsGroup.getHeaderCrosstabs().iterator();
        while (iterator.hasNext()) {
            JRDesignRectangle rect;
            djcross = (DJCrosstab)iterator.next();
            djcb = new Dj2JrCrosstabBuilder();
            crosst = djcb.createCrosstab(djcross, this);
            band = (JRDesignBand)jgroup.getGroupHeader();
            if (djcross.getBottomSpace() != 0) {
                rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), 0);
                LayoutUtils.moveBandsElemnts(rect.getHeight(), band);
                band.addElement((JRDesignElement)rect);
            }
            LayoutUtils.moveBandsElemnts(crosst.getHeight(), band);
            band.addElement((JRDesignElement)crosst);
            if (djcross.getTopSpace() == 0) continue;
            LayoutUtils.moveBandsElemnts(djcross.getTopSpace(), band);
            rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), 0);
            band.addElement((JRDesignElement)rect);
        }
        iterator = columnsGroup.getFooterCrosstabs().iterator();
        while (iterator.hasNext()) {
            JRDesignRectangle rect;
            djcross = (DJCrosstab)iterator.next();
            djcb = new Dj2JrCrosstabBuilder();
            crosst = djcb.createCrosstab(djcross, this);
            band = (JRDesignBand)jgroup.getGroupFooter();
            int yOffset = LayoutUtils.findVerticalOffset(band);
            if (djcross.getTopSpace() != 0) {
                rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), yOffset);
                rect.setPositionType((byte)2);
                band.addElement((JRDesignElement)rect);
                crosst.setY(rect.getY() + rect.getHeight());
            }
            band.addElement((JRDesignElement)crosst);
            if (djcross.getBottomSpace() == 0) continue;
            rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), crosst.getY() + crosst.getHeight());
            band.addElement((JRDesignElement)rect);
        }
    }

    protected JRDesignRectangle createBlankRectableCrosstab(int amount, int yOffset) {
        JRDesignRectangle rect = new JRDesignRectangle();
        rect.setPen(Border.NO_BORDER.getValue());
        rect.setMode(Transparency.TRANSPARENT.getValue());
        rect.setWidth(this.getReport().getOptions().getPrintableWidth());
        rect.setHeight(amount);
        rect.setY(yOffset);
        rect.setPositionType((byte)1);
        return rect;
    }

    protected JRDesignTextField createColumnNameTextField(DJGroup columnsGroup, AbstractColumn col) {
        JRDesignTextField designStaticText = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("\"" + col.getTitle() + "\"");
        exp.setValueClass(String.class);
        designStaticText.setExpression((JRExpression)exp);
        designStaticText.setHeight(columnsGroup.getHeaderHeight().intValue());
        designStaticText.setWidth(col.getWidth().intValue());
        designStaticText.setX(col.getPosX().intValue());
        designStaticText.setY(col.getPosY().intValue());
        Style headerStyle = columnsGroup.getColumnHeaderStyle(col);
        if (headerStyle == null) {
            headerStyle = columnsGroup.getDefaultColumnHeaederStyle();
        }
        if (headerStyle == null) {
            headerStyle = col.getHeaderStyle();
        }
        this.applyStyleToElement(headerStyle, (JRDesignElement)designStaticText);
        return designStaticText;
    }

    protected void layoutGroupSubreports(DJGroup columnsGroup, JRDesignGroup jgroup) {
        log.debug((Object)"Starting subreport layout...");
        JRDesignBand footerBand = (JRDesignBand)jgroup.getGroupFooter();
        JRDesignBand headerBand = (JRDesignBand)jgroup.getGroupHeader();
        this.layOutSubReportInBand(columnsGroup, headerBand, "header");
        this.layOutSubReportInBand(columnsGroup, footerBand, "footer");
    }

    protected void layOutSubReportInBand(DJGroup columnsGroup, JRDesignBand band, String position) {
        List subreportsList = "footer".equals(position) ? columnsGroup.getFooterSubreports() : columnsGroup.getHeaderSubreports();
        Iterator iterator = subreportsList.iterator();
        while (iterator.hasNext()) {
            JRDesignExpression connectionExpression;
            Subreport sr = (Subreport)iterator.next();
            JRDesignSubreport subreport = new JRDesignSubreport(new JRDesignStyle().getDefaultStyleProvider());
            int dataSourceOrigin = sr.getDatasource().getDataSourceOrigin();
            if (10 == dataSourceOrigin) {
                connectionExpression = ExpressionUtils.getReportConnectionExpression();
                subreport.setConnectionExpression((JRExpression)connectionExpression);
            } else if (100 == sr.getDatasource().getDataSourceType()) {
                connectionExpression = ExpressionUtils.getConnectionExpression(sr.getDatasource());
                subreport.setConnectionExpression((JRExpression)connectionExpression);
            } else {
                JRDesignExpression dataSourceExpression = ExpressionUtils.getDataSourceExpression(sr.getDatasource());
                subreport.setDataSourceExpression((JRExpression)dataSourceExpression);
            }
            String paramname = sr.getReport().toString();
            ((DynamicJasperDesign)this.getDesign()).getParametersWithValues().put(paramname, sr.getReport());
            String expText = "(" + (class$net$sf$jasperreports$engine$JasperReport == null ? ClassicLayoutManager.class$("net.sf.jasperreports.engine.JasperReport") : class$net$sf$jasperreports$engine$JasperReport).getName() + ")$P{REPORT_PARAMETERS_MAP}.get( \"" + paramname + "\" )";
            JRDesignExpression srExpression = ExpressionUtils.createExpression(expText, class$net$sf$jasperreports$engine$JasperReport == null ? ClassicLayoutManager.class$("net.sf.jasperreports.engine.JasperReport") : class$net$sf$jasperreports$engine$JasperReport);
            subreport.setExpression((JRExpression)srExpression);
            subreport.setParametersMapExpression((JRExpression)ExpressionUtils.getParameterExpression(sr));
            Iterator subreportParamsIter = sr.getParameters().iterator();
            while (subreportParamsIter.hasNext()) {
                SubreportParameter srparam = (SubreportParameter)subreportParamsIter.next();
                JRDesignSubreportParameter subreportParameter = new JRDesignSubreportParameter();
                subreportParameter.setName(srparam.getName());
                JRDesignExpression expression2 = ExpressionUtils.createExpression(srparam);
                subreportParameter.setExpression((JRExpression)expression2);
                try {
                    subreport.addParameter((JRSubreportParameter)subreportParameter);
                }
                catch (JRException e) {
                    log.error((Object)"Error registering parameter for subreport, there must be another parameter with the same name");
                    throw new CoreException(e.getMessage(), e);
                }
            }
            int offset = LayoutUtils.findVerticalOffset(band);
            subreport.setY(offset);
            subreport.setX(-this.getReport().getOptions().getLeftMargin().intValue());
            subreport.setWidth(this.getReport().getOptions().getPage().getWidth());
            subreport.setHeight(30);
            subreport.setPositionType((byte)1);
            subreport.setStretchType((byte)0);
            subreport.setRemoveLineWhenBlank(true);
            band.setHeight(offset + subreport.getHeight());
            if (sr.getStyle() != null) {
                this.applyStyleToElement(sr.getStyle(), (JRDesignElement)subreport);
            }
            if (sr.isStartInNewPage()) {
                JRDesignGroup jrgroup = this.getJRGroupFromDJGroup(columnsGroup);
                JRDesignBand targetBand = null;
                int idx = this.getDesign().getGroupsList().indexOf(jrgroup);
                if (!"header".equals(position)) {
                    if (idx + 1 < this.getDesign().getGroupsList().size()) {
                        ++idx;
                    }
                    targetBand = (JRDesignBand)((JRDesignGroup)this.getDesign().getGroupsList().get(idx)).getGroupFooter();
                }
                if ("footer".equals(position)) {
                    JRDesignBreak pageBreak = new JRDesignBreak(new JRDesignStyle().getDefaultStyleProvider());
                    pageBreak.setKey(PAGE_BREAK_FOR_ + jrgroup.toString());
                    pageBreak.setY(0);
                    targetBand.addElement((JRDesignElement)pageBreak);
                }
            }
            band.addElement((JRDesignElement)subreport);
            this.sendPageBreakToBottom(band);
            band.setSplitAllowed(sr.isSplitAllowed());
        }
    }

    protected void sendPageBreakToBottom(JRDesignBand band) {
        JRElement[] elems = band.getElements();
        JRElement aux = null;
        for (int i = 0; i < elems.length; ++i) {
            if (!("" + elems[i].getKey()).startsWith(PAGE_BREAK_FOR_)) continue;
            aux = elems[i];
            break;
        }
        if (aux != null) {
            ((JRDesignElement)aux).setY(band.getHeight());
        }
    }

    protected void layoutGroupVariables(DJGroup group, JRDesignGroup jgroup) {
        log.debug((Object)"Starting groups variables layout...");
        JRDesignBand headerBand = (JRDesignBand)jgroup.getGroupHeader();
        JRDesignBand footerBand = (JRDesignBand)jgroup.getGroupFooter();
        int headerOffset = 0;
        int yOffset = 0;
        GroupLayout layout = group.getLayout();
        PropertyColumn column = group.getColumnToGroupBy();
        if (layout.isShowValueInHeader() && layout.isHideColumn() && !layout.isShowColumnName()) {
            JRDesignTextField currentValue = this.generateTextFieldFromColumn(column, this.getReport().getOptions().getDetailHeight(), group);
            currentValue.setWidth(this.getReport().getOptions().getPrintableWidth());
            currentValue.setHeight(FontHelper.getHeightFor(column.getStyle().getFont()));
            LayoutUtils.moveBandsElemnts((yOffset += currentValue.getHeight()) - 1, headerBand);
            headerBand.addElement((JRDesignElement)currentValue);
        } else if (layout.isShowValueInHeader() && !layout.isHideColumn() && !layout.isShowColumnName()) {
            headerOffset = this.changeHeaderBandHeightForVariables(headerBand, group);
            this.insertValueInHeader(headerBand, group, headerOffset);
        } else if (layout.isShowValueInHeader() && layout.isHideColumn() && layout.isShowColumnName()) {
            JRDesignTextField columnNameTf = this.createColumnNameTextField(group, column);
            columnNameTf.setY(columnNameTf.getY() + headerOffset);
            JRDesignTextField currentValue = this.generateTextFieldFromColumn(column, this.getReport().getOptions().getDetailHeight(), group);
            currentValue.setWidth(this.getReport().getOptions().getPrintableWidth() - columnNameTf.getWidth());
            currentValue.setX(columnNameTf.getWidth());
            currentValue.setHeight(FontHelper.getHeightFor(column.getStyle().getFont()));
            columnNameTf.setHeight(currentValue.getHeight());
            LayoutUtils.moveBandsElemnts(yOffset += currentValue.getHeight(), headerBand);
            headerBand.addElement((JRDesignElement)columnNameTf);
            headerBand.addElement((JRDesignElement)currentValue);
        }
        this.placeVariableInBand(group.getHeaderVariables(), group, jgroup, "header", headerBand, headerOffset);
        this.placeVariableInBand(group.getFooterVariables(), group, jgroup, "footer", footerBand, 0);
    }

    protected void placeVariableInBand(List variables, DJGroup columnsGroup, JRDesignGroup jgroup, String type, JRDesignBand band, int yOffset) {
        log.debug((Object)("Placing variables in " + type + " band..."));
        if (variables != null && !variables.isEmpty()) {
            Iterator it = variables.iterator();
            while (it.hasNext()) {
                Style defStyle;
                DJGroupVariable var = (DJGroupVariable)it.next();
                AbstractColumn col = var.getColumnToApplyOperation();
                String variableName = col.getGroupVariableName(type, columnsGroup.getColumnToGroupBy().getColumnProperty().getProperty());
                JRDesignExpression expression = new JRDesignExpression();
                JRDesignTextField textField = new JRDesignTextField();
                expression.setText("$V{" + variableName + "}");
                expression.setValueClassName(col.getVariableClassName(var.getOperation()));
                if (var.getOperation() != DJCalculation.COUNT) {
                    textField.setPattern(col.getPattern());
                }
                textField.setKey(variableName);
                textField.setExpression((JRExpression)expression);
                if ("footer".equals(type)) {
                    textField.setPositionType((byte)2);
                }
                textField.setX(col.getPosX().intValue());
                if (yOffset != 0) {
                    textField.setY(yOffset);
                }
                textField.setHeight(2 + this.getReport().getOptions().getDetailHeight());
                textField.setWidth(col.getWidth().intValue());
                textField.setEvaluationTime((byte)5);
                textField.setEvaluationGroup((JRGroup)jgroup);
                Style style = defStyle = "header".equals(type) ? columnsGroup.getDefaulHeaderVariableStyle() : columnsGroup.getDefaulFooterVariableStyle();
                if (var.getStyle() != null) {
                    this.applyStyleToElement(var.getStyle(), (JRDesignElement)textField);
                } else if (defStyle != null) {
                    this.applyStyleToElement(defStyle, (JRDesignElement)textField);
                } else {
                    Style style2 = col.getStyle();
                    try {
                        style2 = (Style)BeanUtils.cloneBean((Object)style2);
                        style2.setName(null);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.applyStyleToElement(style2, (JRDesignElement)textField);
                }
                band.addElement((JRDesignElement)textField);
            }
            if (columnsGroup.getColumnToGroupBy() instanceof GlobalGroupColumn) {
                int totalWidth = 0;
                DJGroupVariable leftmostColumn = this.findLeftMostColumn(variables);
                totalWidth = leftmostColumn.getColumnToApplyOperation().getPosX();
                GlobalGroupColumn globalCol = (GlobalGroupColumn)columnsGroup.getColumnToGroupBy();
                JRDesignTextField globalTextField = new JRDesignTextField();
                JRDesignExpression globalExp = new JRDesignExpression();
                globalExp.setText(globalCol.getTextForExpression());
                globalExp.setValueClassName(globalCol.getValueClassNameForExpression());
                globalTextField.setExpression((JRExpression)globalExp);
                globalTextField.setHeight(2 + this.getReport().getOptions().getDetailHeight());
                globalTextField.setWidth(totalWidth);
                globalTextField.setX(0);
                if (type.equals("header")) {
                    globalTextField.setY(yOffset);
                }
                globalTextField.setKey("global_legend_" + type);
                this.applyStyleToElement(globalCol.getStyle(), (JRDesignElement)globalTextField);
                band.addElement((JRDesignElement)globalTextField);
            }
        }
    }

    protected DJGroupVariable findLeftMostColumn(List variables) {
        int mostLeftX = Integer.MAX_VALUE;
        DJGroupVariable mostLeftColumn = null;
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            DJGroupVariable currentCol = (DJGroupVariable)iterator.next();
            if (currentCol.getColumnToApplyOperation().getPosX() > mostLeftX) continue;
            mostLeftColumn = currentCol;
            mostLeftX = mostLeftColumn.getColumnToApplyOperation().getPosX();
        }
        return mostLeftColumn;
    }

    protected void insertValueInHeader(JRDesignBand headerBand, DJGroup columnsGroup, int headerOffset) {
        JRDesignTextField textField = this.generateTextFieldFromColumn(columnsGroup.getColumnToGroupBy(), this.getReport().getOptions().getDetailHeight(), columnsGroup);
        textField.setHorizontalAlignment(columnsGroup.getColumnToGroupBy().getStyle().getHorizontalAlign().getValue());
        textField.setStretchType((byte)0);
        textField.setY(textField.getY() + headerOffset);
        headerBand.addElement((JRDesignElement)textField);
    }

    protected int changeHeaderBandHeightForVariables(JRDesignBand headerBand, DJGroup columnsGroup) {
        int result = 0;
        if (!headerBand.getChildren().isEmpty()) {
            int acu = headerBand.getHeight();
            headerBand.setHeight(headerBand.getHeight() + columnsGroup.getHeaderHeight());
            result = acu;
        } else {
            headerBand.setHeight(this.getReport().getOptions().getFooterHeight().intValue());
        }
        return result;
    }

    protected void generateHeaderBand() {
        log.debug((Object)"generating header band...");
        JRDesignBand header = (JRDesignBand)this.getDesign().getColumnHeader();
        if (header == null) {
            header = new JRDesignBand();
            this.getDesign().setColumnHeader((JRBand)header);
        }
        if (this.getReport().getOptions().isPrintColumnNames()) {
            this.generateHeaderBand(header);
        }
    }

    protected void transformDetailBandTextField(AbstractColumn column, JRDesignTextField textField) {
        log.debug((Object)"transforming detail band text field...");
        DJGroup group = DynamicJasperHelper.getColumnGroup(column, this.getReport().getColumnsGroups());
        if (group != null && !group.getLayout().isShowValueForEachRow()) {
            textField.setExpression(null);
        }
    }
}

