/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.core.registration.ColumnsGroupVariablesRegistrationManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.GlobalGroupColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJGroupRegistrationManager
extends AbstractEntityRegistrationManager {
    private static final Log log = LogFactory.getLog((Class)DJGroupRegistrationManager.class);

    public DJGroupRegistrationManager(DynamicJasperDesign jd, DynamicReport dr) {
        super(jd, dr);
    }

    protected void registerEntity(Entity entity) {
        log.debug((Object)"registering group...");
        DJGroup columnsGroup = (DJGroup)entity;
        try {
            JRDesignGroup group = (JRDesignGroup)this.transformEntity(columnsGroup);
            this.getDjd().addGroup(group);
            new ColumnsGroupVariablesRegistrationManager("header", columnsGroup.getColumnToGroupBy().getColumnProperty().getProperty(), this.getDjd(), this.getDynamicReport()).registerEntities(columnsGroup.getHeaderVariables());
            new ColumnsGroupVariablesRegistrationManager("footer", columnsGroup.getColumnToGroupBy().getColumnProperty().getProperty(), this.getDjd(), this.getDynamicReport()).registerEntities(columnsGroup.getFooterVariables());
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage());
        }
    }

    protected Object transformEntity(Entity entity) {
        log.debug((Object)"transforming group...");
        DJGroup columnsGroup = (DJGroup)entity;
        PropertyColumn column = columnsGroup.getColumnToGroupBy();
        JRDesignGroup group = new JRDesignGroup();
        int groupIndex = this.getDynamicReport().getColumnsGroups().indexOf(columnsGroup);
        int columnIndex = this.getDynamicReport().getColumns().indexOf(columnsGroup.getColumnToGroupBy());
        if (column instanceof GlobalGroupColumn) {
            group.setName("global_column_" + groupIndex);
        } else {
            group.setName("group[" + groupIndex + "]_for_column_" + columnIndex + "-" + column.getTitle());
        }
        group.setCountVariable((JRVariable)new JRDesignVariable());
        group.setGroupFooter((JRBand)new JRDesignBand());
        group.setGroupHeader((JRBand)new JRDesignBand());
        JRDesignExpression jrExpression = new JRDesignExpression();
        jrExpression.setText(column.getTextForExpression());
        jrExpression.setValueClassName(column.getValueClassNameForExpression());
        group.setExpression((JRExpression)jrExpression);
        group.setCountVariable((JRVariable)new JRDesignVariable());
        return group;
    }
}

