/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.ColumnsGroupVariableOperation;
import ar.com.fdvs.dj.domain.DJChart;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJQuery;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.ImageBanner;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.builders.SubReportBuilder;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.ColumnsGroup;
import ar.com.fdvs.dj.domain.entities.ColumnsGroupVariable;
import ar.com.fdvs.dj.domain.entities.Parameter;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.GlobalGroupColumn;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;

public class DynamicReportBuilder {
    protected DynamicReport report = new DynamicReport();
    protected DynamicReportOptions options = new DynamicReportOptions();
    protected String grandTotalLegend = "";
    protected ArrayList globalFooterVariables;
    protected ArrayList globalHeaderVariables;
    protected ArrayList globalFooterCrosstabs;
    protected ArrayList globalHeaderCrosstabs;
    protected ArrayList autoTexts;
    protected Map groupFooterSubreports = new HashMap();
    protected Map groupHeaderSubreports = new HashMap();
    protected ArrayList concatenatedReports = new ArrayList();
    private Style grandTotalStyle;

    public DynamicReportBuilder addAutoText(AutoText text) {
        if (this.autoTexts == null) {
            this.autoTexts = new ArrayList();
        }
        this.autoTexts.add(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, byte pattern) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_, pattern);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, byte pattern, int width, int width2) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_, pattern, width, width2);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(String message, byte position, byte alignment) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(message, position, alignment_);
        text.setWidth(AutoText.WIDTH_NOT_SET);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(String message, byte position, byte alignment, int width) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(message, position, alignment_, new Integer(width));
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_);
        text.setWidth(new Integer(width));
        text.setWidth2(new Integer(width2));
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_);
        text.setWidth(AutoText.WIDTH_NOT_SET);
        text.setWidth2(AutoText.WIDTH_NOT_SET);
        this.addAutoText(text);
        return this;
    }

    public DynamicReport build() {
        this.report.setOptions(this.options);
        if (this.globalFooterVariables != null || this.globalHeaderVariables != null) {
            ColumnsGroup globalGroup = this.createDummyGroup();
            this.report.getColumnsGroups().add(0, globalGroup);
        }
        this.addGlobalCrosstabs();
        this.addSubreportsToGroups();
        this.concatenateReports();
        this.report.setAutoTexts(this.autoTexts);
        return this.report;
    }

    private void addGlobalCrosstabs() {
        ColumnsGroup globalGroup;
        DJCrosstab djcross;
        Iterator iterator;
        if (this.globalHeaderCrosstabs != null) {
            iterator = this.globalHeaderCrosstabs.iterator();
            while (iterator.hasNext()) {
                djcross = (DJCrosstab)iterator.next();
                globalGroup = this.createDummyGroupForCrosstabs("crosstabHeaderGroup-" + this.globalHeaderCrosstabs.indexOf(djcross));
                globalGroup.getHeaderCrosstabs().add(djcross);
                this.report.getColumnsGroups().add(0, globalGroup);
            }
        }
        if (this.globalFooterCrosstabs != null) {
            iterator = this.globalFooterCrosstabs.iterator();
            while (iterator.hasNext()) {
                djcross = (DJCrosstab)iterator.next();
                globalGroup = this.createDummyGroupForCrosstabs("crosstabFooterGroup-" + this.globalFooterCrosstabs.indexOf(djcross));
                globalGroup.getFooterCrosstabs().add(djcross);
                this.report.getColumnsGroups().add(0, globalGroup);
            }
        }
    }

    protected void addSubreportsToGroups() {
        ColumnsGroup group;
        List list;
        Integer groupNum;
        Iterator iterator = this.groupFooterSubreports.keySet().iterator();
        while (iterator.hasNext()) {
            groupNum = (Integer)iterator.next();
            list = (List)this.groupFooterSubreports.get(groupNum);
            group = (ColumnsGroup)this.report.getColumnsGroups().get(groupNum - 1);
            group.getFooterSubreports().addAll(list);
        }
        iterator = this.groupHeaderSubreports.keySet().iterator();
        while (iterator.hasNext()) {
            groupNum = (Integer)iterator.next();
            list = (List)this.groupHeaderSubreports.get(groupNum);
            group = (ColumnsGroup)this.report.getColumnsGroups().get(groupNum - 1);
            group.getHeaderSubreports().addAll(list);
        }
    }

    protected void concatenateReports() {
        Iterator iterator = this.concatenatedReports.iterator();
        while (iterator.hasNext()) {
            Subreport subreport = (Subreport)iterator.next();
            ColumnsGroup globalGroup = this.createDummyGroup();
            globalGroup.getFooterSubreports().add(subreport);
            this.report.getColumnsGroups().add(0, globalGroup);
        }
    }

    private ColumnsGroup createDummyGroup() {
        ColumnsGroup globalGroup = new ColumnsGroup();
        globalGroup.setLayout(GroupLayout.EMPTY);
        GlobalGroupColumn globalCol = new GlobalGroupColumn("global");
        globalCol.setTitle(this.grandTotalLegend);
        globalCol.setHeaderStyle(this.grandTotalStyle);
        globalCol.setStyle(this.grandTotalStyle);
        globalGroup.setColumnToGroupBy(globalCol);
        globalGroup.setHeaderVariables(this.globalHeaderVariables);
        globalGroup.setFooterVariables(this.globalFooterVariables);
        return globalGroup;
    }

    private ColumnsGroup createDummyGroupForCrosstabs(String name) {
        ColumnsGroup globalGroup = new ColumnsGroup();
        globalGroup.setLayout(GroupLayout.EMPTY);
        GlobalGroupColumn globalCol = new GlobalGroupColumn(name);
        globalCol.setTitle(this.grandTotalLegend);
        globalCol.setHeaderStyle(this.grandTotalStyle);
        globalCol.setStyle(this.grandTotalStyle);
        globalGroup.setColumnToGroupBy(globalCol);
        return globalGroup;
    }

    public DynamicReportBuilder setTitle(String title) {
        this.report.setTitle(title);
        return this;
    }

    public DynamicReportBuilder setReportName(String reportName) {
        this.report.setReportName(reportName);
        return this;
    }

    public DynamicReportBuilder addSubtitle(String subtitle) {
        return this.setSubtitle(subtitle);
    }

    public DynamicReportBuilder setSubtitle(String subtitle) {
        this.report.setSubtitle(subtitle);
        return this;
    }

    public DynamicReportBuilder addColumn(AbstractColumn column) {
        this.report.getColumns().add(column);
        return this;
    }

    public DynamicReportBuilder addGroup(ColumnsGroup group) {
        this.report.getColumnsGroups().add(group);
        return this;
    }

    public DynamicReportBuilder addHeaderHeight(Integer height) {
        return this.setHeaderHeight(height);
    }

    public DynamicReportBuilder setHeaderHeight(Integer height) {
        this.options.setHeaderHeight(height);
        return this;
    }

    public DynamicReportBuilder addHeaderHeight(int height) {
        return this.setHeaderHeight(height);
    }

    public DynamicReportBuilder setHeaderHeight(int height) {
        this.options.setHeaderHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder addFooterHeight(Integer height) {
        this.options.setFooterHeight(height);
        return this;
    }

    public DynamicReportBuilder setFooterHeight(Integer height) {
        this.options.setFooterHeight(height);
        return this;
    }

    public DynamicReportBuilder addFooterHeight(int height) {
        this.options.setFooterHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder setFooterHeight(int height) {
        this.options.setFooterHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder addDetailHeight(Integer height) {
        this.options.setDetailHeight(height);
        return this;
    }

    public DynamicReportBuilder setDetailHeight(Integer height) {
        this.options.setDetailHeight(height);
        return this;
    }

    public DynamicReportBuilder addDetailHeight(int height) {
        this.options.setDetailHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder setDetailHeight(int height) {
        this.options.setDetailHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder addLeftMargin(Integer margin) {
        this.options.setLeftMargin(margin);
        return this;
    }

    public DynamicReportBuilder setLeftMargin(Integer margin) {
        this.options.setLeftMargin(margin);
        return this;
    }

    public DynamicReportBuilder addLeftMargin(int margin) {
        this.options.setLeftMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setLeftMargin(int margin) {
        this.options.setLeftMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder addRightMargin(Integer margin) {
        this.options.setRightMargin(margin);
        return this;
    }

    public DynamicReportBuilder setRightMargin(Integer margin) {
        this.options.setRightMargin(margin);
        return this;
    }

    public DynamicReportBuilder addRightMargin(int margin) {
        this.options.setRightMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setRightMargin(int margin) {
        this.options.setRightMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder addTopMargin(Integer margin) {
        this.options.setTopMargin(margin);
        return this;
    }

    public DynamicReportBuilder setTopMargin(Integer margin) {
        this.options.setTopMargin(margin);
        return this;
    }

    public DynamicReportBuilder addTopMargin(int margin) {
        this.options.setTopMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setTopMargin(int margin) {
        this.options.setTopMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder addBottomMargin(Integer margin) {
        this.options.setBottomMargin(margin);
        return this;
    }

    public DynamicReportBuilder setBottomMargin(Integer margin) {
        this.options.setBottomMargin(margin);
        return this;
    }

    public DynamicReportBuilder addBottomMargin(int margin) {
        this.options.setBottomMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setBottomMargin(int margin) {
        this.options.setBottomMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder addColumnsPerPage(Integer numColumns) {
        this.options.setColumnsPerPage(numColumns);
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(Integer numColumns) {
        this.options.setColumnsPerPage(numColumns);
        return this;
    }

    public DynamicReportBuilder addColumnsPerPage(int numColumns) {
        this.options.setColumnsPerPage(new Integer(numColumns));
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(int numColumns) {
        this.options.setColumnsPerPage(new Integer(numColumns));
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(int numColumns, int columnSpace) {
        this.options.setColumnsPerPage(new Integer(numColumns));
        this.options.setColumnSpace(new Integer(columnSpace));
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(Integer numColumns, Integer columnSpace) {
        this.options.setColumnsPerPage(numColumns);
        this.options.setColumnSpace(columnSpace);
        return this;
    }

    public DynamicReportBuilder addColumnSpace(Integer columSpace) {
        this.options.setColumnSpace(columSpace);
        return this;
    }

    public DynamicReportBuilder setColumnSpace(Integer columSpace) {
        this.options.setColumnSpace(columSpace);
        return this;
    }

    public DynamicReportBuilder addColumnSpace(int columSpace) {
        this.options.setColumnSpace(new Integer(columSpace));
        return this;
    }

    public DynamicReportBuilder setColumnSpace(int columSpace) {
        this.options.setColumnSpace(new Integer(columSpace));
        return this;
    }

    public DynamicReportBuilder setPrintColumnNames(boolean bool) {
        this.options.setPrintColumnNames(bool);
        return this;
    }

    public DynamicReportBuilder setIgnorePagination(boolean bool) {
        this.options.setIgnorePagination(bool);
        return this;
    }

    public DynamicReportBuilder addUseFullPageWidth(boolean useFullwidth) {
        this.options.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public DynamicReportBuilder setUseFullPageWidth(boolean useFullwidth) {
        this.options.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public DynamicReportBuilder addUseFullPageWidth(Boolean useFullwidth) {
        this.options.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public DynamicReportBuilder setUseFullPageWidth(Boolean useFullwidth) {
        this.options.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public DynamicReportBuilder addTitleStyle(Style titleStyle) {
        this.report.setTitleStyle(titleStyle);
        return this;
    }

    public DynamicReportBuilder setTitleStyle(Style titleStyle) {
        this.report.setTitleStyle(titleStyle);
        return this;
    }

    public DynamicReportBuilder addSubtitleStyle(Style subtitleStyle) {
        this.report.setSubtitleStyle(subtitleStyle);
        return this;
    }

    public DynamicReportBuilder setSubtitleStyle(Style subtitleStyle) {
        this.report.setSubtitleStyle(subtitleStyle);
        return this;
    }

    public DynamicReportBuilder addPrintBackgroundOnOddRows(boolean printBackgroundOnOddRows) {
        this.options.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public DynamicReportBuilder setPrintBackgroundOnOddRows(boolean printBackgroundOnOddRows) {
        this.options.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public DynamicReportBuilder addPrintBackgroundOnOddRows(Boolean printBackgroundOnOddRows) {
        this.options.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public DynamicReportBuilder setPrintBackgroundOnOddRows(Boolean printBackgroundOnOddRows) {
        this.options.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public DynamicReportBuilder addOddRowBackgroundStyle(Style oddRowBackgroundStyle) {
        this.options.setOddRowBackgroundStyle(oddRowBackgroundStyle);
        return this;
    }

    public DynamicReportBuilder setOddRowBackgroundStyle(Style oddRowBackgroundStyle) {
        this.options.setOddRowBackgroundStyle(oddRowBackgroundStyle);
        return this;
    }

    public DynamicReportBuilder addGlobalTitle(String title) {
        this.grandTotalLegend = title;
        return this;
    }

    public DynamicReportBuilder setGrandTotalLegend(String title) {
        this.grandTotalLegend = title;
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn col, ColumnsGroupVariableOperation op) {
        if (this.globalHeaderVariables == null) {
            this.globalHeaderVariables = new ArrayList();
        }
        this.globalHeaderVariables.add(new ColumnsGroupVariable(col, op));
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn col, ColumnsGroupVariableOperation op, Style style) {
        if (this.globalHeaderVariables == null) {
            this.globalHeaderVariables = new ArrayList();
        }
        this.globalHeaderVariables.add(new ColumnsGroupVariable(col, op, style));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn col, ColumnsGroupVariableOperation op) {
        if (this.globalFooterVariables == null) {
            this.globalFooterVariables = new ArrayList();
        }
        this.globalFooterVariables.add(new ColumnsGroupVariable(col, op));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn col, ColumnsGroupVariableOperation op, Style style) {
        if (this.globalFooterVariables == null) {
            this.globalFooterVariables = new ArrayList();
        }
        this.globalFooterVariables.add(new ColumnsGroupVariable(col, op, style));
        return this;
    }

    public DynamicReportBuilder addTitleHeight(Integer height) {
        this.options.setTitleHeight(height);
        return this;
    }

    public DynamicReportBuilder setTitleHeight(Integer height) {
        this.options.setTitleHeight(height);
        return this;
    }

    public DynamicReportBuilder addSubtitleHeight(Integer height) {
        this.options.setSubtitleHeight(height);
        return this;
    }

    public DynamicReportBuilder setSubtitleHeight(Integer height) {
        this.options.setSubtitleHeight(height);
        return this;
    }

    public DynamicReportBuilder setPageSizeAndOrientation(Page page) {
        this.options.setPage(page);
        return this;
    }

    public DynamicReportBuilder addPageSizeAndOrientation(Page page) {
        this.options.setPage(page);
        return this;
    }

    public DynamicReportBuilder addImageBanner(String path, Integer width, Integer height, byte align) {
        ImageBanner banner = new ImageBanner(path, width, height, align);
        this.options.getImageBanners().put(new Byte(align), banner);
        return this;
    }

    public DynamicReportBuilder addFirstPageImageBanner(String path, Integer width, Integer height, byte align) {
        ImageBanner banner = new ImageBanner(path, width, height, align);
        this.options.getFirstPageImageBanners().put(new Byte(align), banner);
        return this;
    }

    public DynamicReportBuilder addField(String name, String className) {
        this.report.getFields().add(new ColumnProperty(name, className));
        return this;
    }

    public DynamicReportBuilder addChart(DJChart chart) {
        this.report.getCharts().add(chart);
        return this;
    }

    public DynamicReportBuilder setTemplateFile(String path) {
        this.report.setTemplateFileName(path);
        return this;
    }

    public DynamicReportBuilder setTemplateFile(String path, boolean importFields, boolean importVariables, boolean importParameters, boolean importDatasets) {
        this.report.setTemplateFileName(path);
        this.report.setTemplateImportFields(importFields);
        this.report.setTemplateImportParameters(importParameters);
        this.report.setTemplateImportVariables(importVariables);
        this.report.setTemplateImportDatasets(importDatasets);
        return this;
    }

    public DynamicReportBuilder addTemplateFile(String path) {
        this.report.setTemplateFileName(path);
        return this;
    }

    public DynamicReportBuilder addMargins(int top, int bottom, int left, int right) {
        this.options.setTopMargin(new Integer(top));
        this.options.setBottomMargin(new Integer(bottom));
        this.options.setLeftMargin(new Integer(left));
        this.options.setRightMargin(new Integer(right));
        return this;
    }

    public DynamicReportBuilder setMargins(int top, int bottom, int left, int right) {
        this.options.setTopMargin(new Integer(top));
        this.options.setBottomMargin(new Integer(bottom));
        this.options.setLeftMargin(new Integer(left));
        this.options.setRightMargin(new Integer(right));
        return this;
    }

    public DynamicReportBuilder setDefaultStyles(Style title, Style subtitle, Style columnHeader, Style columDetail) {
        if (columDetail != null) {
            this.options.setDefaultDetailStyle(columDetail);
        }
        if (columnHeader != null) {
            this.options.setDefaultHeaderStyle(columnHeader);
        }
        if (subtitle != null) {
            this.report.setSubtitleStyle(subtitle);
        }
        if (title != null) {
            this.report.setTitleStyle(title);
        }
        return this;
    }

    public DynamicReportBuilder addDefaultStyles(Style title, Style subtitle, Style columnHeader, Style columDetail) {
        return this.setDefaultStyles(title, subtitle, columnHeader, columDetail);
    }

    public DynamicReportBuilder setReportLocale(Locale locale) {
        this.report.setReportLocale(locale);
        return this;
    }

    public DynamicReportBuilder addReportLocale(Locale locale) {
        this.report.setReportLocale(locale);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(Subreport subreport) {
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).build();
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(JasperReport jasperReport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setReport(jasperReport).build();
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, Subreport subreport) {
        Integer groupNum = new Integer(groupNumber);
        ArrayList<Subreport> list = (ArrayList<Subreport>)this.groupFooterSubreports.get(groupNum);
        if (list == null) {
            list = new ArrayList<Subreport>();
            this.groupFooterSubreports.put(groupNum, list);
        }
        list.add(subreport);
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager).setFitToParentPrintableArea(fitParent);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager).setFitToParentPrintableArea(fitParent);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setPathToReport(pathToSubreport).build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startInNewPage) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setPathToReport(pathToSubreport).setStartInNewPage(startInNewPage).build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, Subreport subreport) {
        Integer groupNum = new Integer(groupNumber);
        ArrayList<Subreport> list = (ArrayList<Subreport>)this.groupHeaderSubreports.get(groupNum);
        if (list == null) {
            list = new ArrayList<Subreport>();
            this.groupHeaderSubreports.put(groupNum, list);
        }
        list.add(subreport);
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setPathToReport(pathToSubreport).build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addStyle(Style style) throws DJBuilderException {
        if (style.getName() == null) {
            throw new DJBuilderException("Invalid style. The style must have a name");
        }
        this.report.addStyle(style);
        return this;
    }

    public DynamicReportBuilder addResourceBundle(String resourceBundle) {
        this.report.setResourceBundle(resourceBundle);
        return this;
    }

    public DynamicReportBuilder setGrandTotalLegendStyle(Style grandTotalStyle) {
        this.grandTotalStyle = grandTotalStyle;
        return this;
    }

    public DynamicReportBuilder addHeaderCrosstab(DJCrosstab cross) {
        if (this.globalHeaderCrosstabs == null) {
            this.globalHeaderCrosstabs = new ArrayList();
        }
        this.globalHeaderCrosstabs.add(cross);
        return this;
    }

    public DynamicReportBuilder addFooterCrosstab(DJCrosstab cross) {
        if (this.globalFooterCrosstabs == null) {
            this.globalFooterCrosstabs = new ArrayList();
        }
        this.globalFooterCrosstabs.add(cross);
        return this;
    }

    public DynamicReportBuilder setQuery(String text, String language) {
        this.report.setQuery(new DJQuery(text, language));
        return this;
    }

    public DynamicReportBuilder addFont(String fontName, Font font) {
        this.report.getFontsMap().put(fontName, font);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataType(byte whenNoDataType) {
        this.report.setWhenNoDataType(whenNoDataType);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataNoPages() {
        this.report.setWhenNoDataType((byte)1);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataBlankPage() {
        this.report.setWhenNoDataType((byte)2);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataAllSectionNoDetail() {
        this.report.setWhenNoDataType((byte)3);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataShowNoDataSection() {
        this.report.setWhenNoDataType((byte)4);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissing(byte whenResourceMissing) {
        this.report.setWhenResourceMissing(whenResourceMissing);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingLeaveEmptySpace() {
        this.report.setWhenResourceMissing((byte)2);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingThrowException() {
        this.report.setWhenResourceMissing((byte)4);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingShowKey() {
        this.report.setWhenResourceMissing((byte)3);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingReturnNull() {
        this.report.setWhenResourceMissing((byte)1);
        return this;
    }

    public DynamicReportBuilder setWhenNoData(String text, Style style) {
        this.report.setWhenNoDataStyle(style);
        this.report.setWhenNoDataText(text);
        this.report.setWhenNoDataType((byte)4);
        return this;
    }

    public DynamicReportBuilder setWhenNoData(String text, Style style, boolean showTitle, boolean showColumnHeader) {
        this.report.setWhenNoDataStyle(style);
        this.report.setWhenNoDataText(text);
        this.report.setWhenNoDataType((byte)4);
        this.report.setWhenNoDataShowColumnHeader(showColumnHeader);
        this.report.setWhenNoDataShowTitle(showTitle);
        return this;
    }

    public DynamicReportBuilder addParameter(String name, String className) {
        this.report.getParameters().add(new Parameter(name, className));
        return this;
    }

    public DynamicReportBuilder setAllowDetailSplit(boolean split) {
        this.report.setAllowDetailSplit(split);
        return this;
    }

    public DynamicReportBuilder setProperty(String name, String value) {
        this.report.setProperty(name, value);
        return this;
    }
}

