/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.domain.ColumnsGroupVariableOperation;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.ColumnsGroup;
import ar.com.fdvs.dj.domain.entities.ColumnsGroupVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.Iterator;

public class GroupBuilder {
    private ColumnsGroup group = new ColumnsGroup();
    private Style defaultFooterVariableStyle;
    private Style defaultHeaderVariableStyle;

    public ColumnsGroup build() {
        ColumnsGroupVariable var;
        Iterator iterator = this.group.getHeaderVariables().iterator();
        while (iterator.hasNext()) {
            var = (ColumnsGroupVariable)iterator.next();
            if (this.defaultHeaderVariableStyle == null) continue;
            var.setStyle(this.defaultHeaderVariableStyle);
        }
        iterator = this.group.getFooterVariables().iterator();
        while (iterator.hasNext()) {
            var = (ColumnsGroupVariable)iterator.next();
            if (this.defaultFooterVariableStyle == null) continue;
            var.setStyle(this.defaultFooterVariableStyle);
        }
        return this.group;
    }

    public GroupBuilder addCriteriaColumn(PropertyColumn column) {
        this.group.setColumnToGroupBy(column);
        return this;
    }

    public GroupBuilder setCriteriaColumn(PropertyColumn column) {
        this.group.setColumnToGroupBy(column);
        return this;
    }

    public GroupBuilder addHeaderVariable(ColumnsGroupVariable variable) {
        this.group.getHeaderVariables().add(variable);
        return this;
    }

    public GroupBuilder addHeaderVariable(AbstractColumn column, ColumnsGroupVariableOperation operation) {
        this.group.getHeaderVariables().add(new ColumnsGroupVariable(column, operation));
        return this;
    }

    public GroupBuilder addHeaderVariable(AbstractColumn column, ColumnsGroupVariableOperation operation, Style style) {
        this.group.getHeaderVariables().add(new ColumnsGroupVariable(column, operation, style));
        return this;
    }

    public GroupBuilder addFooterVariable(ColumnsGroupVariable variable) {
        this.group.getFooterVariables().add(variable);
        return this;
    }

    public GroupBuilder addFooterVariable(AbstractColumn column3, ColumnsGroupVariableOperation operation) {
        this.group.getFooterVariables().add(new ColumnsGroupVariable(column3, operation));
        return this;
    }

    public GroupBuilder addFooterVariable(AbstractColumn column3, ColumnsGroupVariableOperation operation, Style style) {
        this.group.getFooterVariables().add(new ColumnsGroupVariable(column3, operation, style));
        return this;
    }

    public GroupBuilder addHeaderHeight(Integer height) {
        this.group.setHeaderHeight(height);
        return this;
    }

    public GroupBuilder setHeaderHeight(Integer height) {
        this.group.setHeaderHeight(height);
        return this;
    }

    public GroupBuilder addFooterHeight(Integer height) {
        this.group.setFooterHeight(height);
        return this;
    }

    public GroupBuilder setFooterHeight(Integer height) {
        this.group.setFooterHeight(height);
        return this;
    }

    public GroupBuilder addGroupLayout(GroupLayout layout) {
        this.group.setLayout(layout);
        return this;
    }

    public GroupBuilder setGroupLayout(GroupLayout layout) {
        this.group.setLayout(layout);
        return this;
    }

    public GroupBuilder addDefaultFooterVariableStyle(Style defaultFooterVariableStyle) {
        this.defaultFooterVariableStyle = defaultFooterVariableStyle;
        return this;
    }

    public GroupBuilder setDefaultFooterVariableStyle(Style defaultFooterVariableStyle) {
        this.defaultFooterVariableStyle = defaultFooterVariableStyle;
        return this;
    }

    public GroupBuilder addDefaultHeaderVariableStyle(Style defaultHeaderVariableStyle) {
        this.defaultHeaderVariableStyle = defaultHeaderVariableStyle;
        return this;
    }

    public GroupBuilder setDefaultHeaderVariableStyle(Style defaultHeaderVariableStyle) {
        this.defaultHeaderVariableStyle = defaultHeaderVariableStyle;
        return this;
    }

    public GroupBuilder addHeaderSubreport(Subreport subreport) {
        this.group.getHeaderSubreports().add(subreport);
        return this;
    }

    public GroupBuilder addFooterSubreport(Subreport subreport) {
        this.group.getFooterSubreports().add(subreport);
        return this;
    }

    public GroupBuilder setStartInNewPage(Boolean bool) {
        this.group.setStartInNewPage(bool);
        return this;
    }

    public GroupBuilder setStartInNewPage(boolean bool) {
        this.group.setStartInNewPage(bool);
        return this;
    }

    public GroupBuilder setStartInNewColumn(Boolean bool) {
        this.group.setStartInNewColumn(bool);
        return this;
    }

    public GroupBuilder setStartInNewColumn(boolean bool) {
        this.group.setStartInNewColumn(bool);
        return this;
    }
}

