/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;

public abstract class HorizontalBandAlignment {
    public static final HorizontalBandAlignment RIGHT = new HorizontalBandAlignment(){

        public void align(int totalWidth, int offset, JRDesignBand band, JRDesignElement element) {
            int width = totalWidth - element.getWidth() - offset;
            element.setX(width);
            band.addElement(element);
        }

        public byte getAlignment() {
            return 3;
        }
    };
    public static final HorizontalBandAlignment LEFT = new HorizontalBandAlignment(){

        public void align(int totalWidth, int offset, JRDesignBand band, JRDesignElement element) {
            element.setX(element.getX() + offset);
            band.addElement(element);
        }

        public byte getAlignment() {
            return 1;
        }
    };
    public static final HorizontalBandAlignment CENTER = new HorizontalBandAlignment(){

        public void align(int totalWidth, int offset, JRDesignBand band, JRDesignElement element) {
            element.setX(totalWidth / 2 - element.getWidth() / 2 + offset);
            band.addElement(element);
        }

        public byte getAlignment() {
            return 2;
        }
    };

    public static final HorizontalBandAlignment buildAligment(byte aligment) {
        if (aligment == RIGHT.getAlignment()) {
            return RIGHT;
        }
        if (aligment == LEFT.getAlignment()) {
            return LEFT;
        }
        if (aligment == CENTER.getAlignment()) {
            return CENTER;
        }
        return LEFT;
    }

    public abstract void align(int var1, int var2, JRDesignBand var3, JRDesignElement var4);

    public abstract byte getAlignment();
}

