/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import app.pickmaven.businessdays.HolidaySearcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class PublicHolidayAPI
implements HolidaySearcher {
    public static final String PUBLIC_HOLIDAY_P_RAPIDAPI_COM = "public-holiday.p.rapidapi.com";
    private String endpoint = "https://public-holiday.p.rapidapi.com";
    private String api_key = null;
    private int year = LocalDate.now().getYear();
    private Predicate<? super JsonObject> predicate = p -> true;

    public PublicHolidayAPI(String api_key) {
        this.api_key = api_key;
    }

    public PublicHolidayAPI applyPredicate(Predicate<? super JsonObject> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public List<LocalDate> searchHolidaysFor(String countryCode) throws IOException {
        List<JsonObject> jsonObjects = this.callApi(countryCode);
        return jsonObjects.stream().filter(this.predicate).map(PublicHolidayAPI::getDate).collect(Collectors.toList());
    }

    public List<LocalDate> searchHolidaysFor(String countryCode, int year) throws IOException {
        this.year = year;
        List<JsonObject> jsonObjects = this.callApi(countryCode);
        return jsonObjects.stream().filter(this.predicate).map(PublicHolidayAPI::getDate).collect(Collectors.toList());
    }

    private static LocalDate getDate(JsonObject element) {
        JsonElement date = element.get("date");
        String dateAsString = date.getAsString();
        return LocalDate.parse(dateAsString, DateTimeFormatter.ISO_DATE);
    }

    private List<JsonObject> callApi(String countryCode) throws IOException {
        String uri = this.endpoint + "/" + this.year + "/" + countryCode;
        ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
        HttpGet request = new HttpGet(uri);
        request.setHeader("X-RapidAPI-Host", PUBLIC_HOLIDAY_P_RAPIDAPI_COM);
        request.setHeader("X-RapidAPI-Key", this.api_key);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString((HttpEntity)entity);
            JsonElement el = new JsonParser().parse(result);
            if (el.isJsonObject()) {
                jsonObjects.add(el.getAsJsonObject());
            }
            if (el.isJsonArray()) {
                JsonArray jsonArray = el.getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    jsonObjects.add(element.getAsJsonObject());
                }
            }
        }
        return jsonObjects;
    }
}

