/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import app.pickmaven.businessdays.Holiday;
import app.pickmaven.businessdays.TemporalRange;
import java.time.Duration;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HolidayUtils {
    public static LocalDate getEaster(int year) {
        int dayOfMarch = HolidayUtils.getEasterDelay(year);
        return LocalDate.of(year, 3, 1).plusDays(dayOfMarch - 1);
    }

    public static LocalDate getEasterMonday(int year) {
        int dayOfMarch = HolidayUtils.getEasterDelay(year);
        return LocalDate.of(year, 3, 1).plusDays(dayOfMarch);
    }

    private static int getEasterDelay(int year) {
        if (year < 0) {
            throw new IllegalArgumentException("getEaster: year must be non-negative, but was called with year = " + year);
        }
        int a = year % 19;
        int b = year >> 2;
        int c = b / 25 + 1;
        int d = c * 3 >> 2;
        int e = (a * 19 - (c * 8 + 5) / 25 + d + 15) % 30;
        e += 29578 - a - e * 32 >> 10;
        e -= (year % 7 + b - d + e + 2) % 7;
        return e;
    }

    public static List<Holiday> toHolidayList(List<LocalDate> holidayList) {
        return holidayList.stream().map(date -> new Holiday((LocalDate)date)).collect(Collectors.toList());
    }

    public static List<Holiday> toHolidayListByMonthDay(List<MonthDay> holidayList) {
        return holidayList.stream().map(date -> new Holiday((MonthDay)date)).collect(Collectors.toList());
    }

    public static List<Holiday> toHolidayList(String dayMonthDelimiter, String dateDelimiter, String inputHolidayList) {
        String[] holidaysArr = inputHolidayList.split(dateDelimiter);
        ArrayList<String> holidaysArrList = new ArrayList<String>(Arrays.asList(holidaysArr));
        int currentYear = LocalDate.now().getYear();
        List<LocalDate> localDateList = holidaysArrList.stream().map(dateAsString -> LocalDate.of(currentYear, Integer.parseInt(dateAsString.trim().split(dayMonthDelimiter)[0].trim()), Integer.parseInt(dateAsString.trim().split(dayMonthDelimiter)[1].trim()))).collect(Collectors.toList());
        return HolidayUtils.toHolidayList(localDateList);
    }

    public static String printDuration(Duration diff) {
        return "P" + diff.toDays() + "DT" + HolidayUtils.toHours(diff) + "H" + HolidayUtils.toMinutes(diff) + "M" + HolidayUtils.toSeconds(diff) + "S";
    }

    public static int toHours(Duration diff) {
        return (int)(diff.toHours() % 24L);
    }

    public static int toMinutes(Duration diff) {
        return (int)(diff.toMinutes() % 60L);
    }

    public static int toSeconds(Duration diff) {
        return (int)(diff.getSeconds() % 60L);
    }

    public static void checkYearsOrMonthsValidity(Integer[] yearsOrMonths) {
        for (Integer el : Arrays.asList(yearsOrMonths)) {
            int valueOf_digits = String.valueOf(el).length();
            assert (valueOf_digits != 3 && valueOf_digits <= 4) : "Number of digits must not be greater than 4 neither equal to 3";
        }
    }

    public static void checkYearsValidity(Integer[] years) {
        for (Integer el : Arrays.asList(years)) {
            assert (String.valueOf(el).length() == 4) : "Number of digits must be equal to 4";
        }
    }

    public static boolean isInRange(LocalDate date, TemporalRange range) {
        return date.isAfter(range.getStartingDate()) && date.isBefore(range.getEndingDate());
    }
}

