/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import app.pickmaven.businessdays.HolidayUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;

public class Holiday {
    public static final Holiday HOLIDAY_NOW = new Holiday(LocalDate.now());
    public static final Holiday EASTER = Holiday.getEaster();
    public static final Holiday EASTER_MONDAY = Holiday.getEasterMonday();
    public static final Holiday CHRISTMAS = Holiday.getChristmasDay();
    private final LocalDate date;

    public Holiday(LocalDate date) {
        this.date = date;
    }

    public Holiday(String date, DateTimeFormatter formatter) {
        this.date = LocalDate.parse(date, formatter);
    }

    public Holiday(String date, String formatter) {
        this.date = LocalDate.parse(date, DateTimeFormatter.ofPattern(formatter));
    }

    public Holiday(String date, SimpleDateFormat formatter) {
        this.date = LocalDate.parse(date, DateTimeFormatter.ofPattern(formatter.toPattern()));
    }

    public Holiday(Date date) {
        this.date = LocalDate.from(date.toInstant().atZone(ZoneId.systemDefault()));
    }

    public Holiday(MonthDay date) {
        this.date = date.atYear(LocalDate.now().getYear());
    }

    public static Holiday today() {
        return HOLIDAY_NOW;
    }

    public static Holiday of(int year, int month, int day) {
        return new Holiday(LocalDate.of(year, month, day));
    }

    private static Holiday getEaster() {
        LocalDate easter = HolidayUtils.getEaster(LocalDate.now().getYear());
        return new Holiday(easter);
    }

    private static Holiday getEasterMonday() {
        LocalDate easterMonday = HolidayUtils.getEasterMonday(LocalDate.now().getYear());
        return new Holiday(easterMonday);
    }

    public static Holiday getEasterMonday(int year) {
        LocalDate easterMonday = HolidayUtils.getEasterMonday(year);
        return new Holiday(easterMonday);
    }

    private static Holiday getChristmasDay() {
        return new Holiday(LocalDate.of(LocalDate.now().getYear(), 12, 25));
    }

    public LocalDate getDate() {
        return this.date;
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonth().getValue();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Holiday holiday = (Holiday)o;
        return this.getDate().compareTo(holiday.getDate()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getDate());
    }

    public String toString() {
        return "app.pickmaven.businessdays.Holiday{date=" + this.date + '}';
    }
}

