/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import app.pickmaven.businessdays.HolidaySearcher;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.Events;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GoogleCalendarAPI
implements HolidaySearcher {
    private static final String APPLICATION_NAME = "Google Calendar API";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static String token_path = null;
    private Predicate<? super Event> predicate = p -> true;

    public GoogleCalendarAPI(String token_path) {
        GoogleCalendarAPI.token_path = token_path;
    }

    public GoogleCalendarAPI applyPredicate(Predicate<? super Event> predicate) {
        this.predicate = predicate;
        return this;
    }

    private static Credential getCredentials() throws IOException {
        return GoogleCredential.fromStream((InputStream)new FileInputStream(token_path)).createScoped(Collections.singleton("https://www.googleapis.com/auth/calendar.readonly"));
    }

    @Override
    public List<LocalDate> searchHolidaysFor(String countryCode) throws IOException, GeneralSecurityException {
        List<DateTime> holidays = this.getCalendarHolidays(countryCode);
        return holidays.stream().map(DateTime::toString).map(e -> LocalDate.parse(e, DateTimeFormatter.ISO_DATE)).collect(Collectors.toList());
    }

    private List<DateTime> getCalendarHolidays(String countryCode) throws IOException, GeneralSecurityException {
        Events events;
        NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
        Calendar service = new Calendar.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)GoogleCalendarAPI.getCredentials()).setApplicationName(APPLICATION_NAME).build();
        List<DateTime> holidays = null;
        String pageToken = null;
        do {
            events = (Events)service.events().list(countryCode + "#holiday@group.v.calendar.google.com").setPageToken(pageToken).execute();
            List distinctEvents = events.getItems().stream().filter(GoogleCalendarAPI.distinctByKey(p -> p.getStart().getDate())).collect(Collectors.toList());
            holidays = distinctEvents.stream().filter(this.predicate).map(p -> p.getStart().getDate()).distinct().filter(e -> e.toString().contains(String.valueOf(LocalDate.now().getYear()))).collect(Collectors.toList());
        } while ((pageToken = events.getNextPageToken()) != null);
        return holidays;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

