/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import app.pickmaven.businessdays.Holiday;
import app.pickmaven.businessdays.HolidayUtils;
import app.pickmaven.businessdays.Holidays;
import app.pickmaven.businessdays.TemporalRange;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class BusinessDay {
    private Holidays holidays;
    private LocalDate startingDate = LocalDate.now();
    private LocalDate nextBusinessDay;
    private boolean isBusinessSaturday;
    private boolean isBusinessSunday;
    private List<DayOfWeek> holidayOnWeekDays = Collections.EMPTY_LIST;
    private List<Integer> years = Collections.EMPTY_LIST;
    private List<Integer> yearsOrMonths_forBusinessSaturday = Collections.EMPTY_LIST;
    private List<Integer> yearsOrMonths_forBusinessSunday = Collections.EMPTY_LIST;

    private BusinessDay() {
    }

    private boolean checkYearsOrMonthsForSaturday() {
        if (this.yearsOrMonths_forBusinessSaturday.isEmpty()) {
            return true;
        }
        List<Integer> years_forBusinessSaturday = this.getByCharNumber(this.yearsOrMonths_forBusinessSaturday, 4);
        List<Integer> months_forBusinessSaturday = this.getByCharNumber(this.yearsOrMonths_forBusinessSaturday, 2);
        boolean yearsChecked = true;
        boolean monthsChecked = true;
        if (!years_forBusinessSaturday.isEmpty()) {
            yearsChecked = years_forBusinessSaturday.stream().anyMatch(y -> y.equals(this.startingDate.getYear()));
        }
        if (!months_forBusinessSaturday.isEmpty()) {
            monthsChecked = months_forBusinessSaturday.stream().anyMatch(y -> y.equals(this.startingDate.getMonthValue()));
        }
        return yearsChecked && monthsChecked;
    }

    private boolean checkYearsOrMonthsForSunday() {
        if (this.yearsOrMonths_forBusinessSunday.isEmpty()) {
            return true;
        }
        List<Integer> years_forBusinessSunday = this.getByCharNumber(this.yearsOrMonths_forBusinessSunday, 4);
        List<Integer> months_forBusinessSunday = this.getByCharNumber(this.yearsOrMonths_forBusinessSunday, 2);
        boolean yearsChecked = true;
        boolean monthsChecked = true;
        if (!years_forBusinessSunday.isEmpty()) {
            yearsChecked = years_forBusinessSunday.stream().anyMatch(y -> y.equals(this.startingDate.getYear()));
        }
        if (!months_forBusinessSunday.isEmpty()) {
            monthsChecked = months_forBusinessSunday.stream().anyMatch(y -> y.equals(this.startingDate.getMonthValue()));
        }
        return yearsChecked && monthsChecked;
    }

    private List<Integer> getByCharNumber(List<Integer> yearsOrMonths, int digits) {
        assert (yearsOrMonths != null) : "yearsOrMonths must not be null";
        assert (digits == 4 | digits == 2) : "digits must be only 4 or 2";
        return yearsOrMonths.stream().filter(el -> this.normalizeNumber((Integer)el).length() == digits).collect(Collectors.toList());
    }

    private String normalizeNumber(Integer el) {
        String value = String.valueOf(el);
        return value.length() == 1 ? String.format("0%s", value) : value;
    }

    public BusinessDay nextBusinessDay() {
        int addedDays = 0;
        while (addedDays < 1) {
            this.startingDate = this.startingDate.plusDays(1L);
            if (!this.conditionsAreMet()) continue;
            ++addedDays;
        }
        this.nextBusinessDay = this.startingDate;
        return this;
    }

    public BusinessDay nextBusinessDay(int workDays) {
        int addedDays = 0;
        while (addedDays < workDays) {
            this.startingDate = this.startingDate.plusDays(1L);
            if (!this.conditionsAreMet()) continue;
            ++addedDays;
        }
        this.nextBusinessDay = this.startingDate;
        return this;
    }

    private boolean conditionsAreMet() {
        return !this.isHolidayOnSaturday() && !this.isHolidayOnSunday() && !this.isHolidayOnWeekDays() && !this.isHoliday();
    }

    private boolean isHolidayOnSaturday() {
        if (!this.isBusinessSaturday) {
            return this.startingDate.getDayOfWeek() == DayOfWeek.SATURDAY;
        }
        return false;
    }

    private boolean isHolidayOnSunday() {
        if (!this.isBusinessSunday) {
            return this.startingDate.getDayOfWeek() == DayOfWeek.SUNDAY;
        }
        return false;
    }

    private boolean isHolidayOnWeekDays() {
        if (this.checkYears()) {
            return this.holidayOnWeekDays.stream().anyMatch(day -> this.startingDate.getDayOfWeek() == day);
        }
        return false;
    }

    private boolean isHoliday() {
        if (this.checkYears()) {
            return this.holidays.stream().anyMatch(hol -> hol.getDate().isEqual(this.startingDate));
        }
        return false;
    }

    private boolean checkYears() {
        if (this.years.isEmpty()) {
            return true;
        }
        return this.years.stream().anyMatch(y -> y.equals(this.startingDate.getYear()));
    }

    public LocalDate asLocalDate() {
        return this.nextBusinessDay;
    }

    public Date asDate() {
        return Date.from(this.nextBusinessDay.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public Long asLong(int ... hoursMinutesSecondsCommaSeparated) {
        int hours = hoursMinutesSecondsCommaSeparated.length > 0 ? hoursMinutesSecondsCommaSeparated[0] : 0;
        int minutes = hoursMinutesSecondsCommaSeparated.length > 1 ? hoursMinutesSecondsCommaSeparated[1] : 0;
        int seconds = hoursMinutesSecondsCommaSeparated.length == 3 ? hoursMinutesSecondsCommaSeparated[2] : 0;
        ZonedDateTime zdt = ZonedDateTime.of(this.nextBusinessDay, LocalTime.of(hours, minutes, seconds), ZoneId.systemDefault());
        return zdt.toEpochSecond();
    }

    public String asString(DateTimeFormatter formatter) {
        return this.nextBusinessDay.format(formatter);
    }

    public String asString(String pattern) {
        return this.nextBusinessDay.format(DateTimeFormatter.ofPattern(pattern));
    }

    public Period asPeriod() {
        LocalDate today = LocalDate.now();
        return Period.between(today, this.nextBusinessDay);
    }

    public Duration asDuration(String ... hoursMinutesCommaSeparated) {
        for (String s : hoursMinutesCommaSeparated) {
            assert (s.length() <= 2) : "Hours and Minutes cannot contain more than 2 characters";
        }
        String hours = hoursMinutesCommaSeparated.length > 0 ? hoursMinutesCommaSeparated[0] : "00";
        String minutes = hoursMinutesCommaSeparated.length == 2 ? hoursMinutesCommaSeparated[1] : "00";
        hours = hours.length() == 1 ? "0" + hours : hours;
        minutes = minutes.length() == 1 ? "0" + minutes : minutes;
        LocalDateTime oggi = LocalDateTime.now();
        LocalDateTime dataNextWorkingDay = LocalDateTime.parse(this.asString("yyyy-MM-dd") + " " + hours + ":" + minutes, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        return Duration.between(oggi, dataNextWorkingDay);
    }

    public String asDateTimeDuration(String ... hoursMinutesCommaSeparated) {
        Duration duration = this.asDuration(hoursMinutesCommaSeparated);
        if (duration.isNegative()) {
            return "P0DT0H0M0S";
        }
        return HolidayUtils.printDuration(duration);
    }

    public Holidays getHolidays(Integer ... years) {
        HolidayUtils.checkYearsValidity(years);
        if (years.length == 0) {
            List<LocalDate> holidayList = this.holidays.stream().map(Holiday::getDate).collect(Collectors.toList());
            return new Holidays(holidayList);
        }
        List<LocalDate> holidayList = this.holidays.getHolidays().stream().filter(y -> Arrays.asList(years).contains(y.getYear())).map(Holiday::getDate).collect(Collectors.toList());
        return new Holidays(holidayList);
    }

    public Holidays getHolidaysFromNow(Integer ... years) {
        if (years.length > 0) {
            HolidayUtils.checkYearsValidity(years);
            List<LocalDate> holidayList = this.holidays.stream().filter(y -> y.getDate().isAfter(LocalDate.now()) && Arrays.asList(years).contains(y.getYear())).map(Holiday::getDate).collect(Collectors.toList());
            return new Holidays(holidayList);
        }
        List<LocalDate> holidayList = this.holidays.stream().filter(y -> y.getDate().isAfter(LocalDate.now())).map(Holiday::getDate).collect(Collectors.toList());
        return new Holidays(holidayList);
    }

    public Holidays getHolidaysFromStartingDate(Integer ... years) {
        if (years.length > 0) {
            HolidayUtils.checkYearsValidity(years);
            List<LocalDate> holidayList = this.holidays.stream().filter(y -> y.getDate().isAfter(this.startingDate) && Arrays.asList(years).contains(y.getYear())).map(Holiday::getDate).collect(Collectors.toList());
            return new Holidays(holidayList);
        }
        List<LocalDate> holidayList = this.holidays.stream().filter(y -> y.getDate().isAfter(this.startingDate)).map(Holiday::getDate).collect(Collectors.toList());
        return new Holidays(holidayList);
    }

    public Holidays getHolidaysForTemporalRange(TemporalRange range) {
        List<LocalDate> holidayList = this.holidays.stream().filter(holiday -> holiday.getDate().isAfter(range.getStartingDate()) && holiday.getDate().isBefore(range.getEndingDate())).map(Holiday::getDate).collect(Collectors.toList());
        return new Holidays(holidayList);
    }

    private Holidays getHolidays() {
        return this.holidays;
    }

    private void setHolidays(Holidays holidays) {
        this.holidays = holidays;
    }

    private boolean isBusinessSaturday() {
        return this.isBusinessSaturday;
    }

    private void setBusinessSaturday(Integer ... yearsOrMonths) {
        this.yearsOrMonths_forBusinessSaturday = Arrays.asList(yearsOrMonths);
        this.isBusinessSaturday = this.checkYearsOrMonthsForSaturday();
    }

    private void setBusinessSaturday(TemporalRange range) {
        this.isBusinessSaturday = range.includes(this.startingDate);
    }

    private boolean isBusinessSunday() {
        return this.isBusinessSunday;
    }

    private void setBusinessSunday(Integer ... yearsOrMonths) {
        this.yearsOrMonths_forBusinessSunday = Arrays.asList(yearsOrMonths);
        this.isBusinessSunday = this.checkYearsOrMonthsForSunday();
    }

    private void setBusinessSunday(TemporalRange range) {
        this.isBusinessSunday = range.includes(this.startingDate);
    }

    private LocalDate getStartingDate() {
        return this.startingDate;
    }

    private void setStartingDate(LocalDate startingDate) {
        this.startingDate = startingDate;
    }

    private void setHolidayOnWeekDays(DayOfWeek ... weekDays) {
        this.holidayOnWeekDays = Arrays.asList(weekDays);
    }

    private void setYears(Integer ... years) {
        this.years = Arrays.asList(years);
    }

    public static final class Builder {
        private BusinessDay businessDay = new BusinessDay();

        public Builder() {
            this.businessDay.setHolidays(new Holidays());
        }

        public static Builder aBusinessDay() {
            return new Builder();
        }

        public Builder givenHolidays(Holidays holidays) {
            assert (holidays != null) : "app.pickmaven.businessdays.Holidays must not be null";
            Holidays hol = this.businessDay.getHolidays();
            if (hol.addAll(holidays)) {
                this.businessDay.setHolidays(hol);
            }
            return this;
        }

        public Builder computingEaster() {
            Holiday easter = Holiday.EASTER;
            if (!this.businessDay.getHolidays().contains(easter)) {
                this.businessDay.getHolidays().add(easter);
            }
            return this;
        }

        public Builder computingEasterMonday() {
            Holiday easterMonday = null;
            easterMonday = Holiday.EASTER_MONDAY;
            if (this.businessDay.getStartingDate().getYear() != LocalDate.now().getYear()) {
                easterMonday = Holiday.getEasterMonday(this.businessDay.getStartingDate().getYear());
            }
            if (!this.businessDay.getHolidays().contains(easterMonday)) {
                this.businessDay.getHolidays().add(easterMonday);
            }
            return this;
        }

        public Builder computingChristmas() {
            Holiday christmas = Holiday.CHRISTMAS;
            if (!this.businessDay.getHolidays().contains(christmas)) {
                this.businessDay.getHolidays().add(christmas);
            }
            return this;
        }

        public Builder withBusinessSaturday(Integer ... yearsOrMonths) {
            HolidayUtils.checkYearsOrMonthsValidity(yearsOrMonths);
            this.businessDay.setBusinessSaturday(yearsOrMonths);
            return this;
        }

        public Builder withBusinessSaturday(TemporalRange range) {
            assert (range != null) : "Temporal Range must not be null!";
            this.businessDay.setBusinessSaturday(range);
            return this;
        }

        public Builder withBusinessSunday(Integer ... yearsOrMonths) {
            HolidayUtils.checkYearsOrMonthsValidity(yearsOrMonths);
            this.businessDay.setBusinessSunday(yearsOrMonths);
            return this;
        }

        public Builder withBusinessSunday(TemporalRange range) {
            assert (range != null) : "Temporal Range must not be null!";
            this.businessDay.setBusinessSunday(range);
            return this;
        }

        public Builder holidayOnWeekDays(DayOfWeek ... weekDays) {
            this.businessDay.setHolidayOnWeekDays(weekDays);
            return this;
        }

        public Builder holidayOnWeekDays(TemporalRange range, DayOfWeek ... weekDays) {
            assert (range != null) : "Temporal Range must not be null!";
            if (HolidayUtils.isInRange(this.businessDay.getStartingDate(), range)) {
                this.businessDay.setHolidayOnWeekDays(weekDays);
            }
            return this;
        }

        public Builder fromStartingDate(LocalDate startingDate) {
            this.businessDay.setStartingDate(startingDate);
            return this;
        }

        public Builder applyToYears(Integer ... years) {
            HolidayUtils.checkYearsValidity(years);
            this.businessDay.setYears(years);
            return this;
        }

        public BusinessDay build() {
            return this.businessDay;
        }
    }
}

