/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.impl.WxMpServiceOkHttpImpl;
import okhttp3.Request;
import okhttp3.Response;

public class WeChatMpServiceOkHttpImpl
extends WxMpServiceOkHttpImpl {
    private static final JsonParser JSON_PARSER = new JsonParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        this.log.debug("WeChatMpServiceOkHttpImpl getAccessToken is running");
        WxMpConfigStorage wxMpConfigStorage = this.getWxMpConfigStorage();
        if (!forceRefresh && !wxMpConfigStorage.isAccessTokenExpired()) {
            return wxMpConfigStorage.getAccessToken();
        }
        Lock lock = wxMpConfigStorage.getAccessTokenLock();
        try {
            lock.lock();
            String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
            Request request = new Request.Builder().url(url).get().build();
            Response response = this.getRequestHttpClient().newCall(request).execute();
            assert (response.body() != null);
            String resultContent = response.body().string();
            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MP);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
            wxMpConfigStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            String string = accessToken.getAccessToken();
            return string;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        this.log.debug("WeChatMpServiceOkHttpImpl getJsapiTicket is running");
        WxMpConfigStorage wxMpConfigStorage = this.getWxMpConfigStorage();
        if (!forceRefresh && !wxMpConfigStorage.isJsapiTicketExpired()) {
            return wxMpConfigStorage.getJsapiTicket();
        }
        Lock lock = wxMpConfigStorage.getJsapiTicketLock();
        try {
            lock.lock();
            String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi", null);
            JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
            JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
            String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
            int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
            wxMpConfigStorage.updateJsapiTicket(jsapiTicket, expiresInSeconds);
            String string = jsapiTicket;
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

