/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.api.impl;

import app.myoss.cloud.cache.lock.LockService;
import app.myoss.cloud.cache.lock.functions.LockFunction;
import app.myoss.cloud.cache.lock.functions.LockFunctionGeneric;
import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.wechat.mp.api.WeChatMpDynamicConfigStorage;
import app.myoss.wechat.mp.api.impl.LockService4Jdk;
import app.myoss.wechat.mp.autoconfigure.WeChatMpProperties;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.client.RestTemplate;

public class WeChatMpDynamicConfigInRedisStorage
implements WeChatMpDynamicConfigStorage {
    private static final String ACCESS_TOKEN_KEY = "wechat_mp_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_mp_jsapi_ticket_";
    private WeChatMpProperties.WeChatMp weChatMp;
    private RestTemplate restTemplate;
    private LockService lockService;
    private int lockTime;
    private StringRedisTemplate redisTemplate;
    private String accessTokenKey;
    private String jsapiTicketKey;
    private Map<String, LockService4Jdk> lockService4JdkMap = new ConcurrentHashMap<String, LockService4Jdk>();

    public WeChatMpDynamicConfigInRedisStorage(WeChatMpProperties.WeChatMp weChatMp, RestTemplate restTemplate, LockService lockService, int lockTime, StringRedisTemplate redisTemplate) {
        this.weChatMp = weChatMp;
        this.restTemplate = restTemplate;
        this.lockService = lockService;
        this.lockTime = lockTime;
        this.redisTemplate = redisTemplate;
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(weChatMp.getAppId());
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(weChatMp.getAppId());
    }

    @Override
    public String getAccessToken(boolean forceRefresh) {
        if (!forceRefresh && !this.isAccessTokenExpired()) {
            return (String)this.redisTemplate.opsForValue().get((Object)this.accessTokenKey);
        }
        String lockKey = "getAccessTokenLockKey_" + this.accessTokenKey;
        return (String)this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), (LockFunctionGeneric)new LockFunctionGeneric<String>(){

            public String onLockSuccess() {
                return WeChatMpDynamicConfigInRedisStorage.this.getAccessTokenFromWxMpService();
            }

            public String onLockFailed() {
                throw new BizRuntimeException("getAccessToken lock failed");
            }
        });
    }

    public String getAccessTokenFromWxMpService() {
        WeChatMpProperties.WeChatMp weChatMp = this.getWeChatMp();
        String url = String.format(this.getAccessTokenUrl(), weChatMp.getAppId(), weChatMp.getAppSecret());
        String resultContent = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
        WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new BizRuntimeException(error.toString());
        }
        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        return accessToken.getAccessToken();
    }

    public String getAccessTokenUrl() {
        return "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    }

    @Override
    public String getAccessToken() {
        return this.getAccessToken(false);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisTemplate.getExpire((Object)this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public long getExpiresTime() {
        Long expire = this.redisTemplate.getExpire((Object)this.accessTokenKey);
        return expire != null ? expire : -2L;
    }

    @Override
    public void updateAccessToken(final String accessToken, final int expiresInSeconds) {
        String lockKey = "updateAccessTokenLockKey_" + this.accessTokenKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.opsForValue().set((Object)WeChatMpDynamicConfigInRedisStorage.this.accessTokenKey, (Object)accessToken, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("updateAccessToken lock failed");
            }
        });
    }

    @Override
    public void expireAccessToken() {
        String lockKey = "expireAccessTokenLockKey_" + this.accessTokenKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.expire((Object)WeChatMpDynamicConfigInRedisStorage.this.accessTokenKey, 0L, TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("expireAccessToken lock failed");
            }
        });
    }

    @Override
    public Lock getLock(String key) {
        return this.lockService4JdkMap.computeIfAbsent(key, s -> new LockService4Jdk(key, this.lockService));
    }

    @Override
    public String getJsapiTicket(boolean forceRefresh) {
        if (!forceRefresh && !this.isJsapiTicketExpired()) {
            return (String)this.redisTemplate.opsForValue().get((Object)this.jsapiTicketKey);
        }
        String lockKey = "getJsapiTicketLockKey_" + this.jsapiTicketKey;
        return (String)this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), (LockFunctionGeneric)new LockFunctionGeneric<String>(){

            public String onLockSuccess() {
                return WeChatMpDynamicConfigInRedisStorage.this.getJsapiTicketFromWxMpService();
            }

            public String onLockFailed() {
                throw new BizRuntimeException("getJsapiTicket lock failed");
            }
        });
    }

    @Override
    public String getJsapiTicket() {
        return this.getJsapiTicket(false);
    }

    public String getJsapiTicketFromWxMpService() {
        String responseContent = (String)this.restTemplate.getForObject(this.getJsapiTicketUrl(), String.class, new Object[0]);
        JSONObject tmpJsonObject = JSONObject.parseObject((String)responseContent);
        String jsapiTicket = tmpJsonObject.getString("ticket");
        int expiresInSeconds = tmpJsonObject.getIntValue("expires_in");
        this.updateJsapiTicket(jsapiTicket, expiresInSeconds);
        return jsapiTicket;
    }

    public String getJsapiTicketUrl() {
        return "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi";
    }

    @Override
    public boolean isJsapiTicketExpired() {
        Long expire = this.redisTemplate.getExpire((Object)this.jsapiTicketKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void expireJsapiTicket() {
        String lockKey = "expireJsapiTicketLockKey_" + this.jsapiTicketKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.expire((Object)WeChatMpDynamicConfigInRedisStorage.this.jsapiTicketKey, 0L, TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("expireJsapiTicket lock failed");
            }
        });
    }

    @Override
    public void updateJsapiTicket(final String jsapiTicket, final int expiresInSeconds) {
        String lockKey = "updateJsapiTicketLockKey_" + this.jsapiTicketKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.opsForValue().set((Object)WeChatMpDynamicConfigInRedisStorage.this.jsapiTicketKey, (Object)jsapiTicket, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("updateJsapiTicket lock failed");
            }
        });
    }

    public WeChatMpProperties.WeChatMp getWeChatMp() {
        return this.weChatMp;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public String getJsapiTicketKey() {
        return this.jsapiTicketKey;
    }

    public Map<String, LockService4Jdk> getLockService4JdkMap() {
        return this.lockService4JdkMap;
    }
}

