/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.autoconfigure;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wechat.mp")
public class WeChatMpProperties {
    private boolean enabled;
    private WeChatMp config;
    private Map<String, WeChatMp> configs;

    public WeChatMp getByCustomAppId(String customAppId) {
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!customAppId.equals(weChatMp.getCustomAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public WeChatMp getByAppId(String appId) {
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!appId.equals(weChatMp.getAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WeChatMp getConfig() {
        return this.config;
    }

    public Map<String, WeChatMp> getConfigs() {
        return this.configs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfig(WeChatMp config) {
        this.config = config;
    }

    public void setConfigs(Map<String, WeChatMp> configs) {
        this.configs = configs;
    }

    public static class WeChatMp {
        private String appName;
        private String customAppId;
        private String appId;
        @JSONField(serialize=false)
        private String appSecret;
        @JSONField(serialize=false)
        private String token;
        @JSONField(serialize=false)
        private String encodingAesKey;

        public String toString() {
            return JSON.toJSONString((Object)this);
        }

        public String getAppName() {
            return this.appName;
        }

        public String getCustomAppId() {
            return this.customAppId;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public String getToken() {
            return this.token;
        }

        public String getEncodingAesKey() {
            return this.encodingAesKey;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setCustomAppId(String customAppId) {
            this.customAppId = customAppId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setEncodingAesKey(String encodingAesKey) {
            this.encodingAesKey = encodingAesKey;
        }
    }
}

