/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.plugin;

import app.myoss.cloud.mybatis.plugin.ParameterHandlerCustomizer;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class ParameterHandlerInterceptor
implements Interceptor {
    private ParameterHandlerCustomizer parameterHandlerCustomizer;

    public ParameterHandlerInterceptor(ParameterHandlerCustomizer parameterHandlerCustomizer) {
        this.parameterHandlerCustomizer = parameterHandlerCustomizer;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        DefaultParameterHandler target = (DefaultParameterHandler)invocation.getTarget();
        Object parameterObject = target.getParameterObject();
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("mappedStatement");
        BoundSql boundSql = (BoundSql)metaObject.getValue("boundSql");
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        switch (sqlCommandType) {
            case SELECT: {
                this.parameterHandlerCustomizer.handlerSelect(mappedStatement, boundSql, parameterObject);
                break;
            }
            case INSERT: {
                this.parameterHandlerCustomizer.handlerInsert(mappedStatement, boundSql, parameterObject);
                break;
            }
            case UPDATE: {
                this.parameterHandlerCustomizer.handlerUpdate(mappedStatement, boundSql, parameterObject);
                break;
            }
            case DELETE: {
                this.parameterHandlerCustomizer.handlerDelete(mappedStatement, boundSql, parameterObject);
                break;
            }
            case FLUSH: {
                this.parameterHandlerCustomizer.handlerFlush(mappedStatement, boundSql, parameterObject);
                break;
            }
            default: {
                this.parameterHandlerCustomizer.handlerUnknown(mappedStatement, boundSql, parameterObject);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof ParameterHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public ParameterHandlerCustomizer getParameterHandlerCustomizer() {
        return this.parameterHandlerCustomizer;
    }
}

