/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.sequence.impl;

import app.myoss.cloud.sequence.Sequence;
import app.myoss.cloud.sequence.SequenceLifecycle;
import app.myoss.cloud.sequence.SequenceRange;
import app.myoss.cloud.sequence.SequenceRepository;
import app.myoss.cloud.sequence.exception.SequenceException;
import app.myoss.cloud.sequence.impl.RdsSequenceRepository;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.codehaus.commons.nullanalysis.NotNull;

public class DefaultSequenceImpl
implements SequenceLifecycle,
Sequence {
    private final Lock lock = new ReentrantLock();
    private volatile SequenceRange sequenceRange;
    @NonNull
    private SequenceRepository sequenceRepository;
    @NotNull
    private String name;

    @Override
    public void init() {
        if (this.sequenceRepository == null || this.name == null) {
            throw new NullPointerException("sequenceRepository or name is empty");
        }
        this.sequenceRepository.init();
        if (this.sequenceRepository instanceof RdsSequenceRepository) {
            RdsSequenceRepository rdsSequenceRepository = (RdsSequenceRepository)this.sequenceRepository;
            rdsSequenceRepository.adjust(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextValue(Object ... params) throws SequenceException {
        long value;
        if (this.getSequenceRange() == null) {
            this.lock.lock();
            try {
                if (this.getSequenceRange() == null) {
                    this.setSequenceRange(this.sequenceRepository.nextRange(this.name));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.getSequenceRange().getAndIncrement()) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.getSequenceRange().isOver()) {
                        this.setSequenceRange(this.sequenceRepository.nextRange(this.name));
                    }
                    if ((value = this.getSequenceRange().getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new SequenceException("Sequence value overflow, value = " + value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextValue(int size) throws SequenceException {
        long value;
        if (size > this.sequenceRepository.getInnerStep()) {
            throw new SequenceException("batch size > sequence step step, please change batch size or sequence inner step");
        }
        if (this.getSequenceRange() == null) {
            this.lock.lock();
            try {
                if (this.getSequenceRange() == null) {
                    this.setSequenceRange(this.sequenceRepository.nextRange(this.name));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.getSequenceRange().getBatch(size)) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.getSequenceRange().isOver()) {
                        this.setSequenceRange(this.sequenceRepository.nextRange(this.name));
                    }
                    if ((value = this.getSequenceRange().getBatch(size)) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new SequenceException("Sequence value overflow, value = " + value);
        }
        return value;
    }

    public void setSequenceRange(SequenceRange sequenceRange) {
        this.sequenceRange = sequenceRange;
    }

    public SequenceRange getSequenceRange() {
        return this.sequenceRange;
    }

    public void setSequenceRepository(@NonNull SequenceRepository sequenceRepository) {
        if (sequenceRepository == null) {
            throw new NullPointerException("sequenceRepository is marked @NonNull but is null");
        }
        this.sequenceRepository = sequenceRepository;
    }

    @NonNull
    public SequenceRepository getSequenceRepository() {
        return this.sequenceRepository;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

