/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.mapper.register;

import app.myoss.cloud.mybatis.mapper.annotation.RegisterMapper;
import app.myoss.cloud.mybatis.mapper.template.AbstractMapperTemplate;
import app.myoss.cloud.mybatis.table.TableConfig;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;

public class MapperInterfaceRegister {
    private Map<Class<?>, Future<AbstractMapperTemplate>> mapperTemplateCached;
    private Map<Class<?>, TableInfo> registerEntityClass;
    private TableConfig tableConfig;
    private Configuration configuration;
    private Set<Class<? extends Annotation>> sqlProviderAnnotationTypes;

    public MapperInterfaceRegister(TableConfig tableConfig) {
        Objects.requireNonNull(tableConfig, "tableConfig is null");
        this.tableConfig = tableConfig;
        this.sqlProviderAnnotationTypes = new HashSet<Class<? extends Annotation>>();
        this.sqlProviderAnnotationTypes.add(SelectProvider.class);
        this.sqlProviderAnnotationTypes.add(InsertProvider.class);
        this.sqlProviderAnnotationTypes.add(UpdateProvider.class);
        this.sqlProviderAnnotationTypes.add(DeleteProvider.class);
        this.mapperTemplateCached = new ConcurrentHashMap();
        this.registerEntityClass = new ConcurrentHashMap();
    }

    public void executeRegister(Class<?> mapperInterface) {
        Class<?> entityClass = TableMetaObject.getEntityClassByMapperInterface(mapperInterface);
        if (entityClass == null || this.registerEntityClass.containsKey(entityClass)) {
            return;
        }
        TableInfo tableInfo = TableMetaObject.getTableInfoByMapperInterface(mapperInterface, this.tableConfig, this.configuration);
        this.registerEntityClass.put(entityClass, tableInfo);
        this.scanRegisterMapper(tableInfo, mapperInterface);
    }

    private void scanRegisterMapper(TableInfo tableInfo, Class<?> mapperInterface) {
        Class<?>[] interfaces;
        for (Class<?> item : interfaces = mapperInterface.getInterfaces()) {
            if (item.isAnnotationPresent(RegisterMapper.class)) {
                this.processRegisterMapper(tableInfo, item);
            }
            this.scanRegisterMapper(tableInfo, item);
        }
    }

    public void processRegisterMapper(TableInfo tableInfo, Class<?> mapperClass) {
        Method[] methods = mapperClass.getDeclaredMethods();
        if (methods.length == 0) {
            return;
        }
        LinkedHashMap<Class, HashSet> methodSet = new LinkedHashMap<Class, HashSet>();
        for (Method method : methods) {
            String name = method.getName();
            int count = 0;
            for (Class<? extends Annotation> sqlProvider : this.sqlProviderAnnotationTypes) {
                Class providerType;
                Annotation provider = method.getAnnotation(sqlProvider);
                if (provider == null) continue;
                try {
                    providerType = (Class)provider.getClass().getMethod("type", new Class[0]).invoke((Object)provider, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new BuilderException("Error creating SqlProvider.  Cause: ", (Throwable)e);
                }
                if (!AbstractMapperTemplate.class.isAssignableFrom(providerType)) continue;
                if (count > 1) {
                    throw new BindingException("You cannot supply both more than one SqlProvider to method named " + name);
                }
                methodSet.computeIfAbsent(providerType, k -> new HashSet()).add(name);
                ++count;
            }
        }
        for (Map.Entry entry : methodSet.entrySet()) {
            Class templateClass = (Class)entry.getKey();
            AbstractMapperTemplate templateInstance = this.getMapperTemplate(templateClass);
            HashSet value = (HashSet)entry.getValue();
            String canonicalName = tableInfo.getMapperInterfaceClass().getCanonicalName();
            for (String methodName : value) {
                MappedStatement mappedStatement = this.configuration.getMappedStatement(canonicalName + "." + methodName);
                try {
                    Method method = templateClass.getMethod(methodName, TableInfo.class, MappedStatement.class);
                    method.invoke((Object)templateInstance, tableInfo, mappedStatement);
                }
                catch (NoSuchMethodException e) {
                    throw new BindingException(canonicalName + " not found method \"" + methodName + "\" in " + templateClass, (Throwable)e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new BindingException((Throwable)e);
                }
            }
        }
    }

    public AbstractMapperTemplate getMapperTemplate(Class<?> mapperTemplate) {
        FutureTask<AbstractMapperTemplate> task;
        FutureTask<AbstractMapperTemplate> future = this.mapperTemplateCached.get(mapperTemplate);
        if (future == null && (future = (FutureTask<AbstractMapperTemplate>)this.mapperTemplateCached.putIfAbsent(mapperTemplate, task = new FutureTask<AbstractMapperTemplate>(() -> {
            try {
                return (AbstractMapperTemplate)mapperTemplate.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BindingException("new instance of " + mapperTemplate + " failed", (Throwable)e);
            }
        }))) == null) {
            future = task;
            task.run();
        }
        try {
            AbstractMapperTemplate method = future.get();
            if (method == null) {
                this.mapperTemplateCached.remove(mapperTemplate);
            }
            return method;
        }
        catch (InterruptedException | ExecutionException e) {
            this.mapperTemplateCached.remove(mapperTemplate);
            throw new BindingException("getMapperTemplate failed", (Throwable)e);
        }
    }

    public Map<Class<?>, TableInfo> getRegisterEntityClass() {
        return this.registerEntityClass;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<Class<? extends Annotation>> getSqlProviderAnnotationTypes() {
        return this.sqlProviderAnnotationTypes;
    }
}

