/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator.types.impl;

import app.myoss.cloud.mybatis.generator.types.impl.PrimitiveTypeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class FullyQualifiedJavaType
implements Comparable<FullyQualifiedJavaType> {
    private static final String JAVA_LANG = "java.lang";
    private static FullyQualifiedJavaType INT_INSTANCE = null;
    private static FullyQualifiedJavaType STRING_INSTANCE = null;
    private static FullyQualifiedJavaType BOOLEAN_PRIMITIVE_INSTANCE = null;
    private static FullyQualifiedJavaType OBJECT_INSTANCE = null;
    private static FullyQualifiedJavaType DATE_INSTANCE = null;
    private static FullyQualifiedJavaType CRITERIA_INSTANCE = null;
    private static FullyQualifiedJavaType GENERATED_CRITERIA_INSTANCE = null;
    private String baseShortName;
    private String baseQualifiedName;
    private boolean explicitlyImported;
    private String packageName;
    private boolean primitive;
    private boolean isArray;
    private PrimitiveTypeWrapper primitiveTypeWrapper;
    private List<FullyQualifiedJavaType> typeArguments = new ArrayList<FullyQualifiedJavaType>();
    private boolean wildcardType;
    private boolean boundedWildcard;
    private boolean extendsBoundedWildcard;

    public FullyQualifiedJavaType(String fullTypeSpecification) {
        this.parse(fullTypeSpecification);
    }

    private String getString(String key, String parm1) {
        return String.format(key, parm1);
    }

    public String getFullyQualifiedName() {
        StringBuilder sb = new StringBuilder();
        if (this.wildcardType) {
            sb.append('?');
            if (this.boundedWildcard) {
                if (this.extendsBoundedWildcard) {
                    sb.append(" extends ");
                } else {
                    sb.append(" super ");
                }
                sb.append(this.baseQualifiedName);
            }
        } else {
            sb.append(this.baseQualifiedName);
        }
        if (this.typeArguments.size() > 0) {
            boolean first = true;
            sb.append('<');
            for (FullyQualifiedJavaType fqjt : this.typeArguments) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(fqjt.getFullyQualifiedName());
            }
            sb.append('>');
        }
        return sb.toString();
    }

    public List<String> getImportList() {
        ArrayList<String> answer = new ArrayList<String>();
        if (this.isExplicitlyImported()) {
            int index = this.baseShortName.indexOf(46);
            if (index == -1) {
                answer.add(this.calculateActualImport(this.baseQualifiedName));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(this.packageName);
                sb.append('.');
                sb.append(this.calculateActualImport(this.baseShortName.substring(0, index)));
                answer.add(sb.toString());
            }
        }
        for (FullyQualifiedJavaType fqjt : this.typeArguments) {
            answer.addAll(fqjt.getImportList());
        }
        return answer;
    }

    private String calculateActualImport(String name) {
        int index;
        String answer = name;
        if (this.isArray() && (index = name.indexOf("[")) != -1) {
            answer = name.substring(0, index);
        }
        return answer;
    }

    public String getShortName() {
        StringBuilder sb = new StringBuilder();
        if (this.wildcardType) {
            sb.append('?');
            if (this.boundedWildcard) {
                if (this.extendsBoundedWildcard) {
                    sb.append(" extends ");
                } else {
                    sb.append(" super ");
                }
                sb.append(this.baseShortName);
            }
        } else {
            sb.append(this.baseShortName);
        }
        if (this.typeArguments.size() > 0) {
            boolean first = true;
            sb.append('<');
            for (FullyQualifiedJavaType fqjt : this.typeArguments) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(fqjt.getShortName());
            }
            sb.append('>');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FullyQualifiedJavaType)) {
            return false;
        }
        FullyQualifiedJavaType other = (FullyQualifiedJavaType)obj;
        return this.getFullyQualifiedName().equals(other.getFullyQualifiedName());
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public static FullyQualifiedJavaType getIntInstance() {
        if (INT_INSTANCE == null) {
            INT_INSTANCE = new FullyQualifiedJavaType("int");
        }
        return INT_INSTANCE;
    }

    public static FullyQualifiedJavaType getNewMapInstance() {
        return new FullyQualifiedJavaType("java.util.Map");
    }

    public static FullyQualifiedJavaType getNewListInstance() {
        return new FullyQualifiedJavaType("java.util.List");
    }

    public static FullyQualifiedJavaType getNewHashMapInstance() {
        return new FullyQualifiedJavaType("java.util.HashMap");
    }

    public static FullyQualifiedJavaType getNewArrayListInstance() {
        return new FullyQualifiedJavaType("java.util.ArrayList");
    }

    public static FullyQualifiedJavaType getNewIteratorInstance() {
        return new FullyQualifiedJavaType("java.util.Iterator");
    }

    public static FullyQualifiedJavaType getStringInstance() {
        if (STRING_INSTANCE == null) {
            STRING_INSTANCE = new FullyQualifiedJavaType("java.lang.String");
        }
        return STRING_INSTANCE;
    }

    public static FullyQualifiedJavaType getBooleanPrimitiveInstance() {
        if (BOOLEAN_PRIMITIVE_INSTANCE == null) {
            BOOLEAN_PRIMITIVE_INSTANCE = new FullyQualifiedJavaType("boolean");
        }
        return BOOLEAN_PRIMITIVE_INSTANCE;
    }

    public static FullyQualifiedJavaType getObjectInstance() {
        if (OBJECT_INSTANCE == null) {
            OBJECT_INSTANCE = new FullyQualifiedJavaType("java.lang.Object");
        }
        return OBJECT_INSTANCE;
    }

    public static FullyQualifiedJavaType getDateInstance() {
        if (DATE_INSTANCE == null) {
            DATE_INSTANCE = new FullyQualifiedJavaType("java.util.Date");
        }
        return DATE_INSTANCE;
    }

    @Override
    public int compareTo(FullyQualifiedJavaType other) {
        return this.getFullyQualifiedName().compareTo(other.getFullyQualifiedName());
    }

    public void addTypeArgument(FullyQualifiedJavaType type) {
        this.typeArguments.add(type);
    }

    private void parse(String fullTypeSpecification) {
        String spec = fullTypeSpecification.trim();
        if (spec.startsWith("?")) {
            this.wildcardType = true;
            if ((spec = spec.substring(1).trim()).startsWith("extends ")) {
                this.boundedWildcard = true;
                this.extendsBoundedWildcard = true;
                spec = spec.substring(8);
            } else if (spec.startsWith("super ")) {
                this.boundedWildcard = true;
                this.extendsBoundedWildcard = false;
                spec = spec.substring(6);
            } else {
                this.boundedWildcard = false;
            }
            this.parse(spec);
        } else {
            int index = fullTypeSpecification.indexOf(60);
            if (index == -1) {
                this.simpleParse(fullTypeSpecification);
            } else {
                this.simpleParse(fullTypeSpecification.substring(0, index));
                int endIndex = fullTypeSpecification.lastIndexOf(62);
                if (endIndex == -1) {
                    throw new RuntimeException(this.getString("Invalid Type Specification: %.", fullTypeSpecification));
                }
                this.genericParse(fullTypeSpecification.substring(index, endIndex + 1));
            }
            this.isArray = fullTypeSpecification.endsWith("]");
        }
    }

    private void simpleParse(String typeSpecification) {
        this.baseQualifiedName = typeSpecification.trim();
        if (this.baseQualifiedName.contains(".")) {
            this.packageName = FullyQualifiedJavaType.getPackage(this.baseQualifiedName);
            this.baseShortName = this.baseQualifiedName.substring(this.packageName.length() + 1);
            int index = this.baseShortName.lastIndexOf(46);
            if (index != -1) {
                this.baseShortName = this.baseShortName.substring(index + 1);
            }
            this.explicitlyImported = !JAVA_LANG.equals(this.packageName);
        } else {
            this.baseShortName = this.baseQualifiedName;
            this.explicitlyImported = false;
            this.packageName = "";
            if ("byte".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getByteInstance();
            } else if ("short".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getShortInstance();
            } else if ("int".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getIntegerInstance();
            } else if ("long".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getLongInstance();
            } else if ("char".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getCharacterInstance();
            } else if ("float".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getFloatInstance();
            } else if ("double".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getDoubleInstance();
            } else if ("boolean".equals(this.baseQualifiedName)) {
                this.primitive = true;
                this.primitiveTypeWrapper = PrimitiveTypeWrapper.getBooleanInstance();
            } else {
                this.primitive = false;
                this.primitiveTypeWrapper = null;
            }
        }
    }

    private void genericParse(String genericSpecification) {
        int lastIndex = genericSpecification.lastIndexOf(62);
        if (lastIndex == -1) {
            throw new RuntimeException(this.getString("Invalid Type Specification: %.", genericSpecification));
        }
        String argumentString = genericSpecification.substring(1, lastIndex);
        StringTokenizer st = new StringTokenizer(argumentString, ",<>", true);
        int openCount = 0;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("<".equals(token)) {
                sb.append(token);
                ++openCount;
                continue;
            }
            if (">".equals(token)) {
                sb.append(token);
                --openCount;
                continue;
            }
            if (",".equals(token)) {
                if (openCount == 0) {
                    this.typeArguments.add(new FullyQualifiedJavaType(sb.toString()));
                    sb.setLength(0);
                    continue;
                }
                sb.append(token);
                continue;
            }
            sb.append(token);
        }
        if (openCount != 0) {
            throw new RuntimeException(this.getString("Invalid Type Specification: %.", genericSpecification));
        }
        String finalType = sb.toString();
        if (StringUtils.isNotEmpty((CharSequence)finalType)) {
            this.typeArguments.add(new FullyQualifiedJavaType(finalType));
        }
    }

    private static String getPackage(String baseQualifiedName) {
        int index = baseQualifiedName.lastIndexOf(46);
        return baseQualifiedName.substring(0, index);
    }

    public String getBaseShortName() {
        return this.baseShortName;
    }

    public String getBaseQualifiedName() {
        return this.baseQualifiedName;
    }

    public boolean isExplicitlyImported() {
        return this.explicitlyImported;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public PrimitiveTypeWrapper getPrimitiveTypeWrapper() {
        return this.primitiveTypeWrapper;
    }

    public List<FullyQualifiedJavaType> getTypeArguments() {
        return this.typeArguments;
    }

    public boolean isWildcardType() {
        return this.wildcardType;
    }

    public boolean isBoundedWildcard() {
        return this.boundedWildcard;
    }

    public boolean isExtendsBoundedWildcard() {
        return this.extendsBoundedWildcard;
    }
}

