/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator.template.impl;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.mybatis.generator.config.Configuration;
import app.myoss.cloud.mybatis.generator.template.TemplateEngine;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkerTemplateImpl
implements TemplateEngine {
    private freemarker.template.Configuration configuration;

    @Override
    public void init(Configuration config) {
        this.configuration = new freemarker.template.Configuration(freemarker.template.Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setClassForTemplateLoading(FreemarkerTemplateImpl.class, "/");
    }

    @Override
    public void writer(String templatePath, String outputPath, Map<String, Object> data) {
        try {
            Template template = this.configuration.getTemplate(templatePath);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(outputPath));
            template.process(data, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            fileOutputStream.close();
        }
        catch (Exception ex) {
            throw new BizRuntimeException("process [" + templatePath + "] writer to [" + outputPath + "] failed, \ndata: " + data, (Throwable)ex);
        }
    }

    @Override
    public void writer(String templatePath, Writer output, Map<String, Object> data) {
        try {
            Template template = this.configuration.getTemplate(templatePath);
            template.process(data, output);
        }
        catch (Exception ex) {
            throw new BizRuntimeException("process [" + templatePath + "] writer to [" + output.getClass() + "] failed, \ndata: " + data, (Throwable)ex);
        }
    }

    public freemarker.template.Configuration getConfiguration() {
        return this.configuration;
    }
}

