/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator.db.dialect;

import app.myoss.cloud.mybatis.generator.db.dialect.DatabaseDialect;
import app.myoss.cloud.mybatis.generator.db.dialect.impl.H2Dialect;
import app.myoss.cloud.mybatis.generator.db.dialect.impl.MySqlDialect;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DatabaseDialects {
    DB2("DB2", "VALUES IDENTITY_VAL_LOCAL()"),
    MYSQL("MySQL", "SELECT LAST_INSERT_ID()"),
    SQLSERVER("SqlServer", "SELECT SCOPE_IDENTITY()"),
    CLOUDSCAPE("Cloudscape", "VALUES IDENTITY_VAL_LOCAL()"),
    DERBY("Derby", "VALUES IDENTITY_VAL_LOCAL()"),
    HSQLDB("HSQLDB", "CALL IDENTITY()"),
    SYBASE("SYBASE", "SELECT @@IDENTITY"),
    DB2_MF("DB2_MF", "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1"),
    INFORMIX("Informix", "select dbinfo('sqlca.sqlerrd1') from systables where tabid=1"),
    H2("H2", "CALL IDENTITY()");

    String databaseName;
    String identityRetrievalStatement;
    private static Map<DatabaseDialects, DatabaseDialect> DATABASE_DIALECT_MAP;

    public static void registerDatabaseDialect(DatabaseDialects install, DatabaseDialect databaseDialect) {
        DATABASE_DIALECT_MAP.put(install, databaseDialect);
    }

    public static DatabaseDialects getDatabaseDialect(String database) {
        for (DatabaseDialects item : DatabaseDialects.values()) {
            if (!item.getDatabaseName().equalsIgnoreCase(database)) continue;
            return item;
        }
        return null;
    }

    public static Map<DatabaseDialects, DatabaseDialect> getDatabaseDialectMap() {
        return DATABASE_DIALECT_MAP;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getIdentityRetrievalStatement() {
        return this.identityRetrievalStatement;
    }

    private DatabaseDialects(String databaseName, String identityRetrievalStatement) {
        this.databaseName = databaseName;
        this.identityRetrievalStatement = identityRetrievalStatement;
    }

    static {
        DATABASE_DIALECT_MAP = new ConcurrentHashMap<DatabaseDialects, DatabaseDialect>();
        DATABASE_DIALECT_MAP.put(MYSQL, new MySqlDialect());
        DATABASE_DIALECT_MAP.put(H2, new H2Dialect());
    }
}

