/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator.db;

import app.myoss.cloud.mybatis.generator.config.BaseConfiguration;
import app.myoss.cloud.mybatis.generator.config.TableConfiguration;
import app.myoss.cloud.mybatis.generator.db.Column;
import app.myoss.cloud.mybatis.generator.db.IndexInfo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class Table
extends BaseConfiguration {
    private String tableName;
    private String escapedTableName;
    private List<Column> columns = new ArrayList<Column>();
    private List<Column> primaryKeyColumns = new ArrayList<Column>();
    private List<Column> indexColumns = new ArrayList<Column>();
    private String remarks;
    private String tableType;
    private boolean isAutoIncrement;

    public Table() {
        this.entityImportPackages = new LinkedHashSet();
        this.mapperImportPackages = new LinkedHashSet();
        this.serviceImportPackages = new LinkedHashSet();
        this.serviceImplImportPackages = new LinkedHashSet();
        this.webImportPackages = new LinkedHashSet();
    }

    public void customize(TableConfiguration tc) {
    }

    public Table addPrimaryKeyColumn(String columnName) {
        for (Column column : this.columns) {
            if (!column.getColumnName().equals(columnName)) continue;
            this.primaryKeyColumns.add(column);
            column.setPrimaryKey(true);
            break;
        }
        return this;
    }

    public Table addIndexColumn(IndexInfo indexInfo) {
        String columnName = indexInfo.getColumnName();
        for (Column column : this.columns) {
            if (!column.getColumnName().equals(columnName)) continue;
            this.indexColumns.add(column);
            column.setIndexColumn(true);
            column.setIndexInfo(indexInfo);
            break;
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$escapedTableName = this.getEscapedTableName();
        String other$escapedTableName = other.getEscapedTableName();
        if (this$escapedTableName == null ? other$escapedTableName != null : !this$escapedTableName.equals(other$escapedTableName)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<Column> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<Column> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        if (this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns)) {
            return false;
        }
        List<Column> this$indexColumns = this.getIndexColumns();
        List<Column> other$indexColumns = other.getIndexColumns();
        if (this$indexColumns == null ? other$indexColumns != null : !((Object)this$indexColumns).equals(other$indexColumns)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        return this.isAutoIncrement() == other.isAutoIncrement();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $escapedTableName = this.getEscapedTableName();
        result = result * 59 + ($escapedTableName == null ? 43 : $escapedTableName.hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<Column> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        List<Column> $indexColumns = this.getIndexColumns();
        result = result * 59 + ($indexColumns == null ? 43 : ((Object)$indexColumns).hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
        return result;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEscapedTableName() {
        return this.escapedTableName;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Column> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<Column> getIndexColumns() {
        return this.indexColumns;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getTableType() {
        return this.tableType;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setEscapedTableName(String escapedTableName) {
        this.escapedTableName = escapedTableName;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setPrimaryKeyColumns(List<Column> primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public void setIndexColumns(List<Column> indexColumns) {
        this.indexColumns = indexColumns;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setAutoIncrement(boolean isAutoIncrement) {
        this.isAutoIncrement = isAutoIncrement;
    }

    @Override
    public String toString() {
        return "Table(tableName=" + this.getTableName() + ", escapedTableName=" + this.getEscapedTableName() + ", columns=" + this.getColumns() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ", indexColumns=" + this.getIndexColumns() + ", remarks=" + this.getRemarks() + ", tableType=" + this.getTableType() + ", isAutoIncrement=" + this.isAutoIncrement() + ")";
    }
}

