/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.code.format.eclipse.imports.impl;

import app.myoss.cloud.code.format.eclipse.imports.ImportsSorter;
import app.myoss.cloud.code.format.eclipse.utils.ImportsUtils;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImportsSorter450
implements ImportsSorter {
    private List<String> importOrder = new ArrayList<String>();
    private Set<String> allImportOrderItems = new HashSet<String>();
    private Comparator<String> comparator;

    public ImportsSorter450(List<String> importOrder) {
        ArrayList<String> importOrderCopy = new ArrayList<String>(importOrder);
        this.normalizeStaticOrderItems(importOrderCopy);
        this.putStaticItemIfNotExists(importOrderCopy);
        this.importOrder.addAll(importOrderCopy);
        this.allImportOrderItems.addAll(importOrderCopy);
        this.comparator = (o1, o2) -> {
            String containerName1 = this.allImportOrderItems.contains(o1) ? o1 : ImportsUtils.getPackage(o1);
            String simpleName1 = this.allImportOrderItems.contains(o1) ? "" : ImportsUtils.getSimpleName(o1);
            String containerName2 = this.allImportOrderItems.contains(o2) ? o2 : ImportsUtils.getPackage(o2);
            String simpleName2 = this.allImportOrderItems.contains(o2) ? "" : ImportsUtils.getSimpleName(o2);
            int i = containerName1.compareTo(containerName2);
            if (i == 0) {
                i = simpleName1.compareTo(simpleName2);
            }
            return i;
        };
    }

    @Override
    public String sort(List<String> imports) {
        ArrayList<String> template = new ArrayList<String>(this.importOrder);
        ArrayListMultimap matchingImports = ArrayListMultimap.create();
        ArrayList<String> notMatching = new ArrayList<String>();
        this.filterMatchingImports(imports, (ArrayListMultimap<String, String>)matchingImports, notMatching);
        this.mergeNotMatchingItems(false, template, notMatching);
        this.mergeNotMatchingItems(true, template, notMatching);
        this.mergeMatchingItems(template, (ArrayListMultimap<String, String>)matchingImports);
        return ImportsUtils.getImportResult(template);
    }

    private void putStaticItemIfNotExists(List<String> allImportOrderItems) {
        boolean contains = false;
        int indexOfFirstStatic = 0;
        for (int i = 0; i < allImportOrderItems.size(); ++i) {
            String allImportOrderItem = allImportOrderItems.get(i);
            if ("static ".equals(allImportOrderItem)) {
                contains = true;
            }
            if (!allImportOrderItem.startsWith("static ")) continue;
            indexOfFirstStatic = i;
        }
        if (!contains) {
            allImportOrderItems.add(indexOfFirstStatic, "static ");
        }
    }

    private void normalizeStaticOrderItems(List<String> allImportOrderItems) {
        for (int i = 0; i < allImportOrderItems.size(); ++i) {
            String s = allImportOrderItems.get(i);
            if (!s.startsWith("\\#") && !s.startsWith("#")) continue;
            allImportOrderItems.set(i, s.replace("\\#", "static ").replace("#", "static "));
        }
    }

    private void filterMatchingImports(List<String> imports, ArrayListMultimap<String, String> matchingImports, ArrayList<String> notMatching) {
        for (String anImport : imports) {
            String orderItem = this.getBestMatchingImportOrderItem(anImport);
            if (orderItem != null) {
                matchingImports.put((Object)orderItem, (Object)anImport);
                continue;
            }
            notMatching.add(anImport);
        }
        notMatching.addAll(this.allImportOrderItems);
    }

    private String getBestMatchingImportOrderItem(String anImport) {
        String matchingImport = null;
        for (String orderItem : this.allImportOrderItems) {
            if (!anImport.startsWith(orderItem)) continue;
            if (matchingImport == null) {
                matchingImport = orderItem;
                continue;
            }
            matchingImport = ImportsUtils.betterMatching(matchingImport, orderItem, anImport);
        }
        return matchingImport;
    }

    private void mergeNotMatchingItems(boolean staticItems, List<String> template, ArrayList<String> notMatching) {
        notMatching.sort(this.comparator);
        int firstIndexOfOrderItem = this.getFirstIndexOfOrderItem(notMatching, template, staticItems);
        int indexOfOrderItem = 0;
        for (String notMatchingItem : notMatching) {
            if (!this.matchesStatic(staticItems, notMatchingItem)) continue;
            boolean isOrderItem = this.isOrderItem(notMatchingItem, staticItems);
            if (isOrderItem) {
                indexOfOrderItem = template.indexOf(notMatchingItem);
                continue;
            }
            if (indexOfOrderItem == 0 && firstIndexOfOrderItem != 0) {
                template.add(firstIndexOfOrderItem, notMatchingItem);
                ++firstIndexOfOrderItem;
                continue;
            }
            if (firstIndexOfOrderItem == 0) {
                if (template.size() > 0 && template.get(template.size() - 1).startsWith("static")) {
                    template.add("\n");
                }
                template.add(notMatchingItem);
                continue;
            }
            template.add(indexOfOrderItem + 1, notMatchingItem);
            ++indexOfOrderItem;
        }
    }

    private boolean isOrderItem(String notMatchingItem, boolean staticItems) {
        boolean contains = this.allImportOrderItems.contains(notMatchingItem);
        return contains && this.matchesStatic(staticItems, notMatchingItem);
    }

    private int getFirstIndexOfOrderItem(List<String> notMatching, List<String> template, boolean staticItems) {
        int firstIndexOfOrderItem = 0;
        for (String notMatchingItem : notMatching) {
            boolean isOrderItem;
            if (!this.matchesStatic(staticItems, notMatchingItem) || !(isOrderItem = this.isOrderItem(notMatchingItem, staticItems))) continue;
            firstIndexOfOrderItem = template.indexOf(notMatchingItem);
            break;
        }
        return firstIndexOfOrderItem;
    }

    private boolean matchesStatic(boolean staticItems, String notMatchingItem) {
        boolean isStatic = notMatchingItem.startsWith("static ");
        return isStatic && staticItems || !isStatic && !staticItems;
    }

    private void mergeMatchingItems(List<String> template, ArrayListMultimap<String, String> matchingImports) {
        for (int i = 0; i < template.size(); ++i) {
            String item = template.get(i);
            if (!this.allImportOrderItems.contains(item)) continue;
            List strings = matchingImports.get((Object)item);
            if (strings == null || strings.isEmpty()) {
                template.remove(i);
                --i;
                continue;
            }
            ArrayList<String> matchingItems = new ArrayList<String>(strings);
            matchingItems.sort(this.comparator);
            template.remove(i);
            if (i != 0 && !template.get(i - 1).equals("\n")) {
                template.add(i, "\n");
                ++i;
            }
            if (i < template.size() && !template.get(i).equals("\n") && !template.get(i).equals("\n")) {
                template.add(i, "\n");
            }
            template.addAll(i, matchingItems);
        }
        if (template.size() > 0 && template.get(template.size() - 1).equals("\n")) {
            template.remove(template.size() - 1);
        }
    }
}

