/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.job;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="myoss-cloud.log.auto-rolling-log-file")
public class AutoRollingLogFileProperties {
    public static final String DEFAULT_CRON = "0 10 0 * * ?";
    private Boolean enabled = true;
    private String cron;
    private List<String> rollingFileAppenderNames;
    private List<String> loggerNames;

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank((CharSequence)this.cron)) {
            this.cron = DEFAULT_CRON;
        }
        if (CollectionUtils.isEmpty(this.rollingFileAppenderNames)) {
            this.rollingFileAppenderNames = Stream.of("infoAppender", "requestInfoAppender", "errorAppender").collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(this.loggerNames)) {
            this.loggerNames = Stream.of("ROOT", "WebRequest").collect(Collectors.toList());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getCron() {
        return this.cron;
    }

    public List<String> getRollingFileAppenderNames() {
        return this.rollingFileAppenderNames;
    }

    public List<String> getLoggerNames() {
        return this.loggerNames;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setRollingFileAppenderNames(List<String> rollingFileAppenderNames) {
        this.rollingFileAppenderNames = rollingFileAppenderNames;
    }

    public void setLoggerNames(List<String> loggerNames) {
        this.loggerNames = loggerNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoRollingLogFileProperties)) {
            return false;
        }
        AutoRollingLogFileProperties other = (AutoRollingLogFileProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        List<String> this$rollingFileAppenderNames = this.getRollingFileAppenderNames();
        List<String> other$rollingFileAppenderNames = other.getRollingFileAppenderNames();
        if (this$rollingFileAppenderNames == null ? other$rollingFileAppenderNames != null : !((Object)this$rollingFileAppenderNames).equals(other$rollingFileAppenderNames)) {
            return false;
        }
        List<String> this$loggerNames = this.getLoggerNames();
        List<String> other$loggerNames = other.getLoggerNames();
        return !(this$loggerNames == null ? other$loggerNames != null : !((Object)this$loggerNames).equals(other$loggerNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoRollingLogFileProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        List<String> $rollingFileAppenderNames = this.getRollingFileAppenderNames();
        result = result * 59 + ($rollingFileAppenderNames == null ? 43 : ((Object)$rollingFileAppenderNames).hashCode());
        List<String> $loggerNames = this.getLoggerNames();
        result = result * 59 + ($loggerNames == null ? 43 : ((Object)$loggerNames).hashCode());
        return result;
    }

    public String toString() {
        return "AutoRollingLogFileProperties(enabled=" + this.getEnabled() + ", cron=" + this.getCron() + ", rollingFileAppenderNames=" + this.getRollingFileAppenderNames() + ", loggerNames=" + this.getLoggerNames() + ")";
    }
}

