/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.cloud.sleuth.concurrent;

import app.myoss.cloud.core.lang.concurrent.ExecutorEngine;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;

public class TraceableExecutorEngine {
    public static ExecutorEngine buildTraceableExecutorService(BeanFactory beanFactory, ExecutorService delegate) {
        TraceableExecutorService traceableExecutorService = new TraceableExecutorService(beanFactory, delegate);
        return new ExecutorEngine((ExecutorService)traceableExecutorService);
    }

    public static ExecutorEngine buildTraceableExecutorService(BeanFactory beanFactory) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TraceableExecutorEngineThreadPool-%d").build();
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(5, 200, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), threadFactory);
        return TraceableExecutorEngine.buildTraceableExecutorService(beanFactory, poolExecutor);
    }
}

