/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.log.method.aspectj;

import app.myoss.cloud.apm.log.method.aspectj.AbstractMonitorMethod;
import app.myoss.cloud.apm.log.method.aspectj.annotation.MonitorMethodAdvice;
import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
@MonitorMethodAdvice
public class MonitorMethodBefore
extends AbstractMonitorMethod {
    private static final Logger log = LoggerFactory.getLogger((String)"MonitorMethod");

    @Pointcut(value="execution(@org.springframework.web.bind.annotation.ExceptionHandler * *(..)) || execution(@org.springframework.scheduling.annotation.Scheduled * *(..)) || @within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogUnMonitor) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogUnMonitor) || @within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAround) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAround)")
    public void unWantToMatch() {
    }

    @Pointcut(value="@within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodBefore) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodBefore)")
    public void wantToMatch() {
    }

    @Pointcut(value="wantToMatch() && ! unWantToMatch()")
    public void allWantToMatch() {
    }

    @Before(value="allWantToMatch()")
    public void doBefore(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        String methodName = signature.getDeclaringTypeName() + "#" + signature.getName();
        Logger logger = LoggerFactory.getLogger((String)methodName);
        JSONObject jsonBefore = new JSONObject();
        jsonBefore.put("start", (Object)System.currentTimeMillis());
        jsonBefore.put("args", (Object)this.convertArgs(joinPoint.getArgs()));
        jsonBefore.put("app", (Object)this.properties.getAppName());
        logger.info(this.toJSONString(jsonBefore));
    }
}

