/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.config;

import app.myoss.cloud.core.constants.DeployEnvEnum;
import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.core.spring.boot.config.CoreCommonEnvironmentPostProcessor;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.ClassUtils;

@EnableConfigurationProperties(value={WebEndpointProperties.class})
@ConditionalOnClass(value={WebEndpointProperties.class})
@Configuration
public class ApmWebEndpointEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
SmartApplicationListener {
    private static final DeferredLog LOGGER = new DeferredLog();
    public static final int DEFAULT_ORDER = -2147483632;
    private int order = -2147483632;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedHashSet<String> include = new LinkedHashSet<String>();
        include.add("health");
        if (!DeployEnvEnum.isCustomizeDev()) {
            map.put("management.server.port", "8088");
        }
        map.put("management.endpoints.enabled-by-default", "true");
        map.put("management.endpoints.web.base-path", "/");
        map.put("management.endpoint.loggers.enabled", "true");
        include.add("loggers");
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (ClassUtils.isPresent((String)"io.prometheus.client.exporter.common.TextFormat", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"io.prometheus.client.CollectorRegistry", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint", (ClassLoader)classLoader)) {
            map.put("management.endpoint.prometheus.enabled", "true");
            map.put("management.metrics.export.prometheus.enabled", "true");
            include.add("prometheus");
        }
        map.put("management.endpoints.web.exposure.include", include);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("config APM WebEndpoint: " + JsonApi.toJson(map)));
        }
        CoreCommonEnvironmentPostProcessor.addOrReplace((MutablePropertySources)propertySources, map);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            LOGGER.replayTo(ApmWebEndpointEnvironmentPostProcessor.class);
        }
    }
}

