/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import libcore.io.BufferIterator;
import libcore.io.Memory;
import libcore.io.MemoryMappedFile;

public class NioBufferIterator
extends BufferIterator {
    private final MemoryMappedFile file;
    private final long address;
    private final int length;
    private final boolean swap;
    private int position;

    NioBufferIterator(MemoryMappedFile file, long address, int length, boolean swap) {
        file.checkNotClosed();
        this.file = file;
        this.address = address;
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        long MAX_VALID_ADDRESS = -1L;
        if (Long.compareUnsigned(address, -1L - (long)length) > 0) {
            throw new IllegalArgumentException("length " + length + " would overflow 64-bit address space");
        }
        this.length = length;
        this.swap = swap;
    }

    @Override
    public void seek(int offset) {
        this.position = offset;
    }

    @Override
    public void skip(int byteCount) {
        this.position += byteCount;
    }

    @Override
    public int pos() {
        return this.position;
    }

    @Override
    public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
        NioBufferIterator.checkDstBounds(dstOffset, dst.length, byteCount);
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekByteArray(this.address + (long)this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
    }

    @Override
    public byte readByte() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 1);
        byte result = Memory.peekByte(this.address + (long)this.position);
        ++this.position;
        return result;
    }

    @Override
    public int readInt() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 4);
        int result = Memory.peekInt(this.address + (long)this.position, this.swap);
        this.position += 4;
        return result;
    }

    @Override
    public void readIntArray(int[] dst, int dstOffset, int intCount) {
        NioBufferIterator.checkDstBounds(dstOffset, dst.length, intCount);
        this.file.checkNotClosed();
        int byteCount = 4 * intCount;
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekIntArray(this.address + (long)this.position, dst, dstOffset, intCount, this.swap);
        this.position += byteCount;
    }

    @Override
    public short readShort() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 2);
        short result = Memory.peekShort(this.address + (long)this.position, this.swap);
        this.position += 2;
        return result;
    }

    private static void checkReadBounds(int position, int length, int byteCount) {
        if (position < 0 || byteCount < 0) {
            throw new IndexOutOfBoundsException("Invalid read args: position=" + position + ", byteCount=" + byteCount);
        }
        int finalReadPos = position + byteCount;
        if (finalReadPos < 0 || finalReadPos > length) {
            throw new IndexOutOfBoundsException("Read outside range: position=" + position + ", byteCount=" + byteCount + ", length=" + length);
        }
    }

    private static void checkDstBounds(int dstOffset, int dstLength, int count) {
        if (dstOffset < 0 || count < 0) {
            throw new IndexOutOfBoundsException("Invalid dst args: offset=" + dstLength + ", count=" + count);
        }
        int targetPos = dstOffset + count;
        if (targetPos < 0 || targetPos > dstLength) {
            throw new IndexOutOfBoundsException("Write outside range: dst.length=" + dstLength + ", offset=" + dstOffset + ", count=" + count);
        }
    }
}

