/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelCpuProcReader;
import com.android.internal.os.KernelUidCpuTimeReaderBase;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;

public class KernelUidCpuActiveTimeReader
extends KernelUidCpuTimeReaderBase<Callback> {
    private static final String TAG = KernelUidCpuActiveTimeReader.class.getSimpleName();
    private final KernelCpuProcReader mProcReader;
    private SparseArray<Double> mLastUidCpuActiveTimeMs = new SparseArray();
    private int mCores;

    public KernelUidCpuActiveTimeReader() {
        this.mProcReader = KernelCpuProcReader.getActiveTimeReaderInstance();
    }

    @VisibleForTesting
    public KernelUidCpuActiveTimeReader(KernelCpuProcReader procReader) {
        this.mProcReader = procReader;
    }

    @Override
    protected void readDeltaImpl(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            double activeTime = this.sumActiveTime((IntBuffer)buf);
            if (activeTime > 0.0) {
                double delta = activeTime - this.mLastUidCpuActiveTimeMs.get(uid, 0.0);
                if (delta > 0.0) {
                    this.mLastUidCpuActiveTimeMs.put(uid, activeTime);
                    if (callback != null) {
                        callback.onUidCpuActiveTime(uid, (long)delta);
                    }
                } else if (delta < 0.0) {
                    Slog.e(TAG, "Negative delta from active time proc: " + delta);
                }
            }
        });
    }

    public void readAbsolute(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            double activeTime = this.sumActiveTime((IntBuffer)buf);
            if (activeTime > 0.0) {
                callback.onUidCpuActiveTime(uid, (long)activeTime);
            }
        });
    }

    private double sumActiveTime(IntBuffer buffer) {
        double sum = 0.0;
        boolean corrupted = false;
        for (int j = 1; j <= this.mCores; ++j) {
            int time = buffer.get();
            if (time < 0) {
                Slog.e(TAG, "Negative time from active time proc: " + time);
                corrupted = true;
                continue;
            }
            sum += (double)time * 10.0 / (double)j;
        }
        return corrupted ? -1.0 : sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImpl(Consumer<IntBuffer> processUid) {
        KernelCpuProcReader kernelCpuProcReader = this.mProcReader;
        synchronized (kernelCpuProcReader) {
            ByteBuffer bytes = this.mProcReader.readBytes();
            if (bytes == null || bytes.remaining() <= 4) {
                return;
            }
            if ((bytes.remaining() & 3) != 0) {
                Slog.wtf(TAG, "Cannot parse active time proc bytes to int: " + bytes.remaining());
                return;
            }
            IntBuffer buf = bytes.asIntBuffer();
            int cores = buf.get();
            if (this.mCores != 0 && cores != this.mCores) {
                Slog.wtf(TAG, "Cpu active time wrong # cores: " + cores);
                return;
            }
            this.mCores = cores;
            if (cores <= 0 || buf.remaining() % (cores + 1) != 0) {
                Slog.wtf(TAG, "Cpu active time format error: " + buf.remaining() + " / " + (cores + 1));
                return;
            }
            int numUids = buf.remaining() / (cores + 1);
            for (int i = 0; i < numUids; ++i) {
                processUid.accept(buf);
            }
        }
    }

    public void removeUid(int uid) {
        this.mLastUidCpuActiveTimeMs.delete(uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        this.mLastUidCpuActiveTimeMs.put(startUid, null);
        this.mLastUidCpuActiveTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidCpuActiveTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidCpuActiveTimeMs.indexOfKey(endUid);
        this.mLastUidCpuActiveTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    public static interface Callback
    extends KernelUidCpuTimeReaderBase.Callback {
        public void onUidCpuActiveTime(int var1, long var2);
    }
}

