/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocaleStore;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class SuggestedLocaleAdapter
extends BaseAdapter
implements Filterable {
    private static final int TYPE_HEADER_SUGGESTED = 0;
    private static final int TYPE_HEADER_ALL_OTHERS = 1;
    private static final int TYPE_LOCALE = 2;
    private static final int MIN_REGIONS_FOR_SUGGESTIONS = 6;
    private ArrayList<LocaleStore.LocaleInfo> mLocaleOptions;
    private ArrayList<LocaleStore.LocaleInfo> mOriginalLocaleOptions;
    private int mSuggestionCount;
    private final boolean mCountryMode;
    private LayoutInflater mInflater;
    private Locale mDisplayLocale = null;
    private Context mContextOverride = null;

    public SuggestedLocaleAdapter(Set<LocaleStore.LocaleInfo> localeOptions, boolean countryMode) {
        this.mCountryMode = countryMode;
        this.mLocaleOptions = new ArrayList(localeOptions.size());
        for (LocaleStore.LocaleInfo li : localeOptions) {
            if (li.isSuggested()) {
                ++this.mSuggestionCount;
            }
            this.mLocaleOptions.add(li);
        }
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled(int position) {
        return this.getItemViewType(position) == 2;
    }

    @Override
    public int getItemViewType(int position) {
        if (!this.showHeaders()) {
            return 2;
        }
        if (position == 0) {
            return 0;
        }
        if (position == this.mSuggestionCount + 1) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getViewTypeCount() {
        if (this.showHeaders()) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getCount() {
        if (this.showHeaders()) {
            return this.mLocaleOptions.size() + 2;
        }
        return this.mLocaleOptions.size();
    }

    @Override
    public Object getItem(int position) {
        int offset = 0;
        if (this.showHeaders()) {
            offset = position > this.mSuggestionCount ? -2 : -1;
        }
        return this.mLocaleOptions.get(position + offset);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void setDisplayLocale(Context context, Locale locale) {
        if (locale == null) {
            this.mDisplayLocale = null;
            this.mContextOverride = null;
        } else if (!locale.equals(this.mDisplayLocale)) {
            this.mDisplayLocale = locale;
            Configuration configOverride = new Configuration();
            configOverride.setLocale(locale);
            this.mContextOverride = context.createConfigurationContext(configOverride);
        }
    }

    private void setTextTo(TextView textView, int resId) {
        if (this.mContextOverride == null) {
            textView.setText(resId);
        } else {
            textView.setText(this.mContextOverride.getText(resId));
        }
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null && this.mInflater == null) {
            this.mInflater = LayoutInflater.from(parent.getContext());
        }
        int itemType = this.getItemViewType(position);
        switch (itemType) {
            case 0: 
            case 1: {
                if (!(convertView instanceof TextView)) {
                    convertView = this.mInflater.inflate(17367164, parent, false);
                }
                TextView textView = (TextView)convertView;
                if (itemType == 0) {
                    this.setTextTo(textView, 17040123);
                } else if (this.mCountryMode) {
                    this.setTextTo(textView, 17040753);
                } else {
                    this.setTextTo(textView, 17040122);
                }
                textView.setTextLocale(this.mDisplayLocale != null ? this.mDisplayLocale : AndroidLocale.getDefault());
                break;
            }
            default: {
                if (!(convertView instanceof ViewGroup)) {
                    convertView = this.mInflater.inflate(17367163, parent, false);
                }
                TextView text = (TextView)convertView.findViewById(16909035);
                LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
                text.setText(item.getLabel(this.mCountryMode));
                text.setTextLocale(item.getLocale());
                text.setContentDescription(item.getContentDescription(this.mCountryMode));
                if (!this.mCountryMode) break;
                int layoutDir = TextUtils.getLayoutDirectionFromLocale(item.getParent());
                convertView.setLayoutDirection(layoutDir);
                text.setTextDirection(layoutDir == 1 ? 4 : 3);
            }
        }
        return convertView;
    }

    private boolean showHeaders() {
        if (this.mCountryMode && this.mLocaleOptions.size() < 6) {
            return false;
        }
        return this.mSuggestionCount != 0 && this.mSuggestionCount != this.mLocaleOptions.size();
    }

    public void sort(LocaleHelper.LocaleInfoComparator comp) {
        Collections.sort(this.mLocaleOptions, comp);
    }

    @Override
    public Filter getFilter() {
        return new FilterByNativeAndUiNames();
    }

    class FilterByNativeAndUiNames
    extends Filter {
        FilterByNativeAndUiNames() {
        }

        @Override
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (SuggestedLocaleAdapter.this.mOriginalLocaleOptions == null) {
                SuggestedLocaleAdapter.this.mOriginalLocaleOptions = new ArrayList(SuggestedLocaleAdapter.this.mLocaleOptions);
            }
            ArrayList values = new ArrayList(SuggestedLocaleAdapter.this.mOriginalLocaleOptions);
            if (prefix == null || prefix.length() == 0) {
                results.values = values;
                results.count = values.size();
            } else {
                Locale locale = AndroidLocale.getDefault();
                String prefixString = LocaleHelper.normalizeForSearch(prefix.toString(), locale);
                int count = values.size();
                ArrayList<LocaleStore.LocaleInfo> newValues = new ArrayList<LocaleStore.LocaleInfo>();
                for (int i = 0; i < count; ++i) {
                    LocaleStore.LocaleInfo value = (LocaleStore.LocaleInfo)values.get(i);
                    String nameToCheck = LocaleHelper.normalizeForSearch(value.getFullNameInUiLanguage(), locale);
                    String nativeNameToCheck = LocaleHelper.normalizeForSearch(value.getFullNameNative(), locale);
                    if (!this.wordMatches(nativeNameToCheck, prefixString) && !this.wordMatches(nameToCheck, prefixString)) continue;
                    newValues.add(value);
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        boolean wordMatches(String valueText, String prefixString) {
            String[] words;
            if (valueText.startsWith(prefixString)) {
                return true;
            }
            for (String word : words = valueText.split(" ")) {
                if (!word.startsWith(prefixString)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            SuggestedLocaleAdapter.this.mLocaleOptions = (ArrayList)results.values;
            SuggestedLocaleAdapter.this.mSuggestionCount = 0;
            for (LocaleStore.LocaleInfo li : SuggestedLocaleAdapter.this.mLocaleOptions) {
                if (!li.isSuggested()) continue;
                SuggestedLocaleAdapter.this.mSuggestionCount++;
            }
            if (results.count > 0) {
                SuggestedLocaleAdapter.this.notifyDataSetChanged();
            } else {
                SuggestedLocaleAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

