/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public interface TextClassifier {
    public static final String DEFAULT_LOG_TAG = "androidtc";
    public static final int LOCAL = 0;
    public static final int SYSTEM = 1;
    public static final String TYPE_UNKNOWN = "";
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_PHONE = "phone";
    public static final String TYPE_ADDRESS = "address";
    public static final String TYPE_URL = "url";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATE_TIME = "datetime";
    public static final String TYPE_FLIGHT_NUMBER = "flight";
    public static final String HINT_TEXT_IS_EDITABLE = "android.text_is_editable";
    public static final String HINT_TEXT_IS_NOT_EDITABLE = "android.text_is_not_editable";
    public static final String WIDGET_TYPE_TEXTVIEW = "textview";
    public static final String WIDGET_TYPE_EDITTEXT = "edittext";
    public static final String WIDGET_TYPE_UNSELECTABLE_TEXTVIEW = "nosel-textview";
    public static final String WIDGET_TYPE_WEBVIEW = "webview";
    public static final String WIDGET_TYPE_EDIT_WEBVIEW = "edit-webview";
    public static final String WIDGET_TYPE_CUSTOM_TEXTVIEW = "customview";
    public static final String WIDGET_TYPE_CUSTOM_EDITTEXT = "customedit";
    public static final String WIDGET_TYPE_CUSTOM_UNSELECTABLE_TEXTVIEW = "nosel-customview";
    public static final String WIDGET_TYPE_UNKNOWN = "unknown";
    public static final TextClassifier NO_OP = new TextClassifier(){};

    default public TextSelection suggestSelection(TextSelection.Request request) {
        Preconditions.checkNotNull(request);
        Utils.checkMainThread();
        return new TextSelection.Builder(request.getStartIndex(), request.getEndIndex()).build();
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
        TextSelection.Request request = new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).setDefaultLocales(defaultLocales).build();
        return this.suggestSelection(request);
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options) {
        if (options == null) {
            return this.suggestSelection(new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).build());
        }
        if (options.getRequest() != null) {
            return this.suggestSelection(options.getRequest());
        }
        return this.suggestSelection(new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).setDefaultLocales(options.getDefaultLocales()).build());
    }

    default public TextClassification classifyText(TextClassification.Request request) {
        Preconditions.checkNotNull(request);
        Utils.checkMainThread();
        return TextClassification.EMPTY;
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
        TextClassification.Request request = new TextClassification.Request.Builder(text, startIndex, endIndex).setDefaultLocales(defaultLocales).build();
        return this.classifyText(request);
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options) {
        if (options == null) {
            return this.classifyText(new TextClassification.Request.Builder(text, startIndex, endIndex).build());
        }
        if (options.getRequest() != null) {
            return this.classifyText(options.getRequest());
        }
        return this.classifyText(new TextClassification.Request.Builder(text, startIndex, endIndex).setDefaultLocales(options.getDefaultLocales()).setReferenceTime(options.getReferenceTime()).build());
    }

    default public TextLinks generateLinks(TextLinks.Request request) {
        Preconditions.checkNotNull(request);
        Utils.checkMainThread();
        return new TextLinks.Builder(request.getText().toString()).build();
    }

    default public TextLinks generateLinks(CharSequence text, TextLinks.Options options) {
        if (options == null) {
            return this.generateLinks(new TextLinks.Request.Builder(text).build());
        }
        if (options.getRequest() != null) {
            return this.generateLinks(options.getRequest());
        }
        return this.generateLinks(new TextLinks.Request.Builder(text).setDefaultLocales(options.getDefaultLocales()).setEntityConfig(options.getEntityConfig()).build());
    }

    default public int getMaxGenerateLinksTextLength() {
        return Integer.MAX_VALUE;
    }

    default public void onSelectionEvent(SelectionEvent event) {
    }

    default public void destroy() {
    }

    default public boolean isDestroyed() {
        return false;
    }

    public static class Utils {
        static void checkArgument(CharSequence text, int startIndex, int endIndex) {
            Preconditions.checkArgument(text != null);
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex <= text.length());
            Preconditions.checkArgument(endIndex > startIndex);
        }

        static void checkTextLength(CharSequence text, int maxLength) {
            Preconditions.checkArgumentInRange(text.length(), 0, maxLength, "text.length()");
        }

        public static TextLinks generateLegacyLinks(TextLinks.Request request) {
            String string2 = request.getText().toString();
            TextLinks.Builder links = new TextLinks.Builder(string2);
            Collection<String> entities = request.getEntityConfig().resolveEntityListModifications(Collections.emptyList());
            if (entities.contains(TextClassifier.TYPE_URL)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_URL);
            }
            if (entities.contains(TextClassifier.TYPE_PHONE)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_PHONE);
            }
            if (entities.contains(TextClassifier.TYPE_EMAIL)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_EMAIL);
            }
            return links.build();
        }

        private static void addLinks(TextLinks.Builder links, String string2, String entityType) {
            SpannableString spannable = new SpannableString(string2);
            if (Linkify.addLinks(spannable, Utils.linkMask(entityType))) {
                URLSpan[] spans;
                for (URLSpan urlSpan : spans = spannable.getSpans(0, spannable.length(), URLSpan.class)) {
                    links.addLink(spannable.getSpanStart(urlSpan), spannable.getSpanEnd(urlSpan), Utils.entityScores(entityType), urlSpan);
                }
            }
        }

        private static int linkMask(String entityType) {
            switch (entityType) {
                case "url": {
                    return 1;
                }
                case "phone": {
                    return 4;
                }
                case "email": {
                    return 2;
                }
            }
            return 0;
        }

        private static Map<String, Float> entityScores(String entityType) {
            ArrayMap<String, Float> scores = new ArrayMap<String, Float>();
            scores.put(entityType, Float.valueOf(1.0f));
            return scores;
        }

        static void checkMainThread() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                Log.w(TextClassifier.DEFAULT_LOG_TAG, "TextClassifier called on main thread");
            }
        }
    }

    public static class EntityConfig
    implements Parcelable {
        private final Collection<String> mHints;
        private final Collection<String> mExcludedEntityTypes;
        private final Collection<String> mIncludedEntityTypes;
        private final boolean mUseHints;
        public static final Parcelable.Creator<EntityConfig> CREATOR = new Parcelable.Creator<EntityConfig>(){

            @Override
            public EntityConfig createFromParcel(Parcel in) {
                return new EntityConfig(in);
            }

            public EntityConfig[] newArray(int size) {
                return new EntityConfig[size];
            }
        };

        private EntityConfig(boolean useHints, Collection<String> hints, Collection<String> includedEntityTypes, Collection<String> excludedEntityTypes) {
            this.mHints = hints == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(new ArraySet<String>(hints));
            this.mExcludedEntityTypes = excludedEntityTypes == null ? Collections.EMPTY_LIST : new ArraySet<String>(excludedEntityTypes);
            this.mIncludedEntityTypes = includedEntityTypes == null ? Collections.EMPTY_LIST : new ArraySet<String>(includedEntityTypes);
            this.mUseHints = useHints;
        }

        public static EntityConfig createWithHints(Collection<String> hints) {
            return new EntityConfig(true, hints, null, null);
        }

        public static EntityConfig create(Collection<String> hints) {
            return EntityConfig.createWithHints(hints);
        }

        public static EntityConfig create(Collection<String> hints, Collection<String> includedEntityTypes, Collection<String> excludedEntityTypes) {
            return new EntityConfig(true, hints, includedEntityTypes, excludedEntityTypes);
        }

        public static EntityConfig createWithExplicitEntityList(Collection<String> entityTypes) {
            return new EntityConfig(false, null, entityTypes, null);
        }

        public static EntityConfig createWithEntityList(Collection<String> entityTypes) {
            return EntityConfig.createWithExplicitEntityList(entityTypes);
        }

        public Collection<String> resolveEntityListModifications(Collection<String> entities) {
            HashSet<String> finalSet = new HashSet<String>();
            if (this.mUseHints) {
                finalSet.addAll(entities);
            }
            finalSet.addAll(this.mIncludedEntityTypes);
            finalSet.removeAll(this.mExcludedEntityTypes);
            return finalSet;
        }

        public Collection<String> getHints() {
            return this.mHints;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeStringList(new ArrayList<String>(this.mHints));
            dest.writeStringList(new ArrayList<String>(this.mExcludedEntityTypes));
            dest.writeStringList(new ArrayList<String>(this.mIncludedEntityTypes));
            dest.writeInt(this.mUseHints ? 1 : 0);
        }

        private EntityConfig(Parcel in) {
            this.mHints = new ArraySet<String>(in.createStringArrayList());
            this.mExcludedEntityTypes = new ArraySet<String>(in.createStringArrayList());
            this.mIncludedEntityTypes = new ArraySet<String>(in.createStringArrayList());
            this.mUseHints = in.readInt() == 1;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Hints {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextClassifierType {
    }
}

