/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.database.ContentObserver;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.textclassifier.TextClassifierService;
import android.view.textclassifier.Log;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSession;
import android.view.textclassifier.TextClassificationSessionFactory;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;

public class TextClassificationManager {
    private static final String LOG_TAG = "TextClassificationManager";
    private final Object mLock = new Object();
    private final TextClassificationSessionFactory mDefaultSessionFactory = classificationContext -> new TextClassificationSession(classificationContext, this.getTextClassifier());
    private final Context mContext;
    private final SettingsObserver mSettingsObserver;
    @GuardedBy(value="mLock")
    private TextClassifier mCustomTextClassifier;
    @GuardedBy(value="mLock")
    private TextClassifier mLocalTextClassifier;
    @GuardedBy(value="mLock")
    private TextClassifier mSystemTextClassifier;
    @GuardedBy(value="mLock")
    private TextClassificationSessionFactory mSessionFactory;
    @GuardedBy(value="mLock")
    private TextClassificationConstants mSettings;

    public TextClassificationManager(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mSessionFactory = this.mDefaultSessionFactory;
        this.mSettingsObserver = new SettingsObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClassifier getTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCustomTextClassifier != null) {
                return this.mCustomTextClassifier;
            }
            if (this.isSystemTextClassifierEnabled()) {
                return this.getSystemTextClassifier();
            }
            return this.getLocalTextClassifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextClassifier(TextClassifier textClassifier) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCustomTextClassifier = textClassifier;
        }
    }

    public TextClassifier getTextClassifier(int type) {
        switch (type) {
            case 0: {
                return this.getLocalTextClassifier();
            }
        }
        return this.getSystemTextClassifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassificationConstants getSettings() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSettings == null) {
                this.mSettings = TextClassificationConstants.loadFromString(Settings.Global.getString(this.getApplicationContext().getContentResolver(), "text_classifier_constants"));
            }
            return this.mSettings;
        }
    }

    public TextClassifier createTextClassificationSession(TextClassificationContext classificationContext) {
        Preconditions.checkNotNull(classificationContext);
        TextClassifier textClassifier = this.mSessionFactory.createTextClassificationSession(classificationContext);
        Preconditions.checkNotNull(textClassifier, "Session Factory should never return null");
        return textClassifier;
    }

    public TextClassifier createTextClassificationSession(TextClassificationContext classificationContext, TextClassifier textClassifier) {
        Preconditions.checkNotNull(classificationContext);
        Preconditions.checkNotNull(textClassifier);
        return new TextClassificationSession(classificationContext, textClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextClassificationSessionFactory(TextClassificationSessionFactory factory) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionFactory = factory != null ? factory : this.mDefaultSessionFactory;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mSettingsObserver != null) {
                this.getApplicationContext().getContentResolver().unregisterContentObserver(this.mSettingsObserver);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassifier getSystemTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSystemTextClassifier == null && this.isSystemTextClassifierEnabled()) {
                try {
                    this.mSystemTextClassifier = new SystemTextClassifier(this.mContext, this.getSettings());
                    Log.d(LOG_TAG, "Initialized SystemTextClassifier");
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    Log.e(LOG_TAG, "Could not initialize SystemTextClassifier", e);
                }
            }
        }
        if (this.mSystemTextClassifier != null) {
            return this.mSystemTextClassifier;
        }
        return TextClassifier.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassifier getLocalTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLocalTextClassifier == null) {
                if (this.getSettings().isLocalTextClassifierEnabled()) {
                    this.mLocalTextClassifier = new TextClassifierImpl(this.mContext, this.getSettings(), TextClassifier.NO_OP);
                } else {
                    Log.d(LOG_TAG, "Local TextClassifier disabled");
                    this.mLocalTextClassifier = TextClassifier.NO_OP;
                }
            }
            return this.mLocalTextClassifier;
        }
    }

    private boolean isSystemTextClassifierEnabled() {
        return this.getSettings().isSystemTextClassifierEnabled() && TextClassifierService.getServiceComponentName(this.mContext) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSettings = null;
            this.mLocalTextClassifier = null;
            this.mSystemTextClassifier = null;
        }
    }

    Context getApplicationContext() {
        return this.mContext.getApplicationContext() != null ? this.mContext.getApplicationContext() : this.mContext;
    }

    public static TextClassificationConstants getSettings(Context context) {
        Preconditions.checkNotNull(context);
        TextClassificationManager tcm = context.getSystemService(TextClassificationManager.class);
        if (tcm != null) {
            return tcm.getSettings();
        }
        return TextClassificationConstants.loadFromString(Settings.Global.getString(context.getApplicationContext().getContentResolver(), "text_classifier_constants"));
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final WeakReference<TextClassificationManager> mTcm;

        SettingsObserver(TextClassificationManager tcm) {
            super(null);
            this.mTcm = new WeakReference<TextClassificationManager>(tcm);
            tcm.getApplicationContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("text_classifier_constants"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            TextClassificationManager tcm = (TextClassificationManager)this.mTcm.get();
            if (tcm != null) {
                tcm.invalidate();
            }
        }
    }
}

