/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.metrics.LogMaker;
import android.view.textclassifier.SelectionEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.text.BreakIterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;

public class SelectionSessionLogger {
    private static final String LOG_TAG = "SelectionSessionLogger";
    private static final boolean DEBUG_LOG_ENABLED = false;
    static final String CLASSIFIER_ID = "androidtc";
    private static final int START_EVENT_DELTA = 1117;
    private static final int PREV_EVENT_DELTA = 1118;
    private static final int INDEX = 1120;
    private static final int WIDGET_TYPE = 1255;
    private static final int WIDGET_VERSION = 1262;
    private static final int MODEL_NAME = 1256;
    private static final int ENTITY_TYPE = 1254;
    private static final int SMART_START = 1252;
    private static final int SMART_END = 1253;
    private static final int EVENT_START = 1250;
    private static final int EVENT_END = 1251;
    private static final int SESSION_ID = 1119;
    private static final String ZERO = "0";
    private static final String UNKNOWN = "unknown";
    private final MetricsLogger mMetricsLogger;

    public SelectionSessionLogger() {
        this.mMetricsLogger = new MetricsLogger();
    }

    @VisibleForTesting
    public SelectionSessionLogger(MetricsLogger metricsLogger) {
        this.mMetricsLogger = Preconditions.checkNotNull(metricsLogger);
    }

    public void writeEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        LogMaker log = new LogMaker(1100).setType(SelectionSessionLogger.getLogType(event)).setSubtype(SelectionSessionLogger.getLogSubType(event)).setPackageName(event.getPackageName()).addTaggedData(1117, event.getDurationSinceSessionStart()).addTaggedData(1118, event.getDurationSincePreviousEvent()).addTaggedData(1120, event.getEventIndex()).addTaggedData(1255, event.getWidgetType()).addTaggedData(1262, event.getWidgetVersion()).addTaggedData(1256, SignatureParser.getModelName(event.getResultId())).addTaggedData(1254, event.getEntityType()).addTaggedData(1252, event.getSmartStart()).addTaggedData(1253, event.getSmartEnd()).addTaggedData(1250, event.getStart()).addTaggedData(1251, event.getEnd());
        if (event.getSessionId() != null) {
            log.addTaggedData(1119, event.getSessionId().flattenToString());
        }
        this.mMetricsLogger.write(log);
        SelectionSessionLogger.debugLog(log);
    }

    private static int getLogType(SelectionEvent event) {
        switch (event.getEventType()) {
            case 100: {
                return 1108;
            }
            case 101: {
                return 1109;
            }
            case 102: {
                return 1110;
            }
            case 103: {
                return 1111;
            }
            case 104: {
                return 1112;
            }
            case 105: {
                return 1113;
            }
            case 106: {
                return 1114;
            }
            case 107: {
                return 1115;
            }
            case 108: {
                return 1116;
            }
            case 200: {
                return 1103;
            }
            case 201: {
                return 1104;
            }
            case 1: {
                return 1101;
            }
            case 2: {
                return 1102;
            }
            case 3: {
                return 1105;
            }
            case 4: {
                return 1106;
            }
            case 5: {
                return 1107;
            }
        }
        return 0;
    }

    private static int getLogSubType(SelectionEvent event) {
        switch (event.getInvocationMethod()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private static String getLogTypeString(int logType) {
        switch (logType) {
            case 1108: {
                return "OVERTYPE";
            }
            case 1109: {
                return "COPY";
            }
            case 1110: {
                return "PASTE";
            }
            case 1111: {
                return "CUT";
            }
            case 1112: {
                return "SHARE";
            }
            case 1113: {
                return "SMART_SHARE";
            }
            case 1114: {
                return "DRAG";
            }
            case 1115: {
                return "ABANDON";
            }
            case 1116: {
                return "OTHER";
            }
            case 1103: {
                return "SELECT_ALL";
            }
            case 1104: {
                return "RESET";
            }
            case 1101: {
                return "SELECTION_STARTED";
            }
            case 1102: {
                return "SELECTION_MODIFIED";
            }
            case 1105: {
                return "SMART_SELECTION_SINGLE";
            }
            case 1106: {
                return "SMART_SELECTION_MULTI";
            }
            case 1107: {
                return "AUTO_SELECTION";
            }
        }
        return UNKNOWN;
    }

    private static String getLogSubTypeString(int logSubType) {
        switch (logSubType) {
            case 1: {
                return "MANUAL";
            }
            case 2: {
                return "LINK";
            }
        }
        return UNKNOWN;
    }

    private static void debugLog(LogMaker log) {
    }

    public static BreakIterator getTokenIterator(Locale locale) {
        return BreakIterator.getWordInstance(Preconditions.checkNotNull(locale));
    }

    public static String createId(String text, int start, int end, Context context, int modelVersion, List<Locale> locales) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(locales);
        StringJoiner localesJoiner = new StringJoiner(",");
        for (Locale locale : locales) {
            localesJoiner.add(AndroidLocale.toLanguageTag(locale));
        }
        String modelName = String.format(Locale.US, "%s_v%d", localesJoiner.toString(), modelVersion);
        int hash = Objects.hash(text, start, end, context.getPackageName());
        return SignatureParser.createSignature(CLASSIFIER_ID, modelName, hash);
    }

    @VisibleForTesting
    public static class SignatureParser {
        static String createSignature(String classifierId, String modelName, int hash) {
            return String.format(Locale.US, "%s|%s|%d", classifierId, modelName, hash);
        }

        static String getClassifierId(String signature) {
            if (signature == null) {
                return "";
            }
            int end = signature.indexOf("|");
            if (end >= 0) {
                return signature.substring(0, end);
            }
            return "";
        }

        static String getModelName(String signature) {
            if (signature == null) {
                return "";
            }
            int start = signature.indexOf("|") + 1;
            int end = signature.indexOf("|", start);
            if (start >= 1 && end >= start) {
                return signature.substring(start, end);
            }
            return "";
        }

        static int getHash(String signature) {
            if (signature == null) {
                return 0;
            }
            int index1 = signature.indexOf("|");
            int index2 = signature.indexOf("|", index1);
            if (index2 > 0) {
                return Integer.parseInt(signature.substring(index2));
            }
            return 0;
        }
    }
}

