/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.graphics.Bitmap;
import android.view.math.Math3DHelper;
import java.util.Arrays;

class TriangleBuffer {
    int mWidth;
    int mHeight;
    int mImgWidth;
    int mImgHeight;
    int mBorder;
    Bitmap mBitmap;
    int[] mData;
    private float mMinX;
    private float mMaxX;
    private float mMinY;
    private float mMaxY;

    TriangleBuffer() {
    }

    public void setSize(int width, int height, int border) {
        if (this.mWidth == width && this.mHeight == height) {
            return;
        }
        this.mWidth = width - 2 * border;
        this.mHeight = height - 2 * border;
        this.mBorder = border;
        this.mImgWidth = width;
        this.mImgHeight = height;
        this.setScale(0.0f, width, 0.0f, height);
        this.mBitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        this.mData = new int[width * height];
    }

    public void drawTriangles(int[] index, float[] vert, float[] color2, float scale) {
        int indexSize = index.length / 3;
        for (int i = 0; i < indexSize; ++i) {
            int vIndex = index[i * 3 + 0];
            float vx = vert[vIndex * 2 + 0];
            float vy = vert[vIndex * 2 + 1];
            float c = scale * color2[vIndex * 4 + 3];
            float fx3 = vx;
            float fy3 = vy;
            float fz3 = c;
            vIndex = index[i * 3 + 1];
            vx = vert[vIndex * 2 + 0];
            vy = vert[vIndex * 2 + 1];
            c = scale * color2[vIndex * 4 + 3];
            float fx2 = vx;
            float fy2 = vy;
            float fz2 = c;
            vIndex = index[i * 3 + 2];
            vx = vert[vIndex * 2 + 0];
            vy = vert[vIndex * 2 + 1];
            c = scale * color2[vIndex * 4 + 3];
            float fx1 = vx;
            float fy1 = vy;
            float fz1 = c;
            TriangleBuffer.triangleZBuffMin(this.mData, this.mImgWidth, this.mImgHeight, fx3, fy3, fz3, fx2, fy2, fz2, fx1, fy1, fz1);
            TriangleBuffer.triangleZBuffMin(this.mData, this.mImgWidth, this.mImgHeight, fx1, fy1, fz1, fx2, fy2, fz2, fx3, fy3, fz3);
        }
        this.mBitmap.setPixels(this.mData, 0, this.mWidth, 0, 0, this.mWidth, this.mHeight);
    }

    public void drawTriangles(float[] strip, float scale) {
        for (int i = 0; i < strip.length - 8; i += 3) {
            float fx3 = strip[i];
            float fy3 = strip[i + 1];
            float fz3 = scale * strip[i + 2];
            float fx2 = strip[i + 3];
            float fy2 = strip[i + 4];
            float fz2 = scale * strip[i + 5];
            float fx1 = strip[i + 6];
            float fy1 = strip[i + 7];
            float fz1 = scale * strip[i + 8];
            if (fx1 * (fy2 - fy3) + fx2 * (fy3 - fy1) + fx3 * (fy1 - fy2) == 0.0f) continue;
            TriangleBuffer.triangleZBuffMin(this.mData, this.mImgWidth, this.mImgHeight, fx3, fy3, fz3, fx2, fy2, fz2, fx1, fy1, fz1);
        }
        this.mBitmap.setPixels(this.mData, 0, this.mWidth, 0, 0, this.mWidth, this.mHeight);
    }

    public Bitmap getImage() {
        return this.mBitmap;
    }

    private static void triangleZBuffMin(int[] buff, int w, int h, float fx3, float fy3, float fz3, float fx2, float fy2, float fz2, float fx1, float fy1, float fz1) {
        double d;
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            float tmpx = fx1;
            float tmpy = fy1;
            float tmpz = fz1;
            fx1 = fx2;
            fy1 = fy2;
            fz1 = fz2;
            fx2 = tmpx;
            fy2 = tmpy;
            fz2 = tmpz;
        }
        if ((d = (double)(fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1)) == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        int y1 = (int)(16.0f * fy1 + 0.5f);
        int y2 = (int)(16.0f * fy2 + 0.5f);
        int y3 = (int)(16.0f * fy3 + 0.5f);
        int x1 = (int)(16.0f * fx1 + 0.5f);
        int x2 = (int)(16.0f * fx2 + 0.5f);
        int x3 = (int)(16.0f * fx3 + 0.5f);
        int dx12 = x1 - x2;
        int dx23 = x2 - x3;
        int dx31 = x3 - x1;
        int dy12 = y1 - y2;
        int dy23 = y2 - y3;
        int dy31 = y3 - y1;
        int fdx12 = dx12 << 4;
        int fdx23 = dx23 << 4;
        int fdx31 = dx31 << 4;
        int fdy12 = dy12 << 4;
        int fdy23 = dy23 << 4;
        int fdy31 = dy31 << 4;
        int minx = Math3DHelper.min(x1, x2, x3) + 15 >> 4;
        int maxx = Math3DHelper.max(x1, x2, x3) + 15 >> 4;
        int miny = Math3DHelper.min(y1, y2, y3) + 15 >> 4;
        int maxy = Math3DHelper.max(y1, y2, y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int c1 = dy12 * x1 - dx12 * y1;
        int c2 = dy23 * x2 - dx23 * y2;
        int c3 = dy31 * x3 - dx31 * y3;
        if (dy12 < 0 || dy12 == 0 && dx12 > 0) {
            ++c1;
        }
        if (dy23 < 0 || dy23 == 0 && dx23 > 0) {
            ++c2;
        }
        if (dy31 < 0 || dy31 == 0 && dx31 > 0) {
            ++c3;
        }
        int cy1 = c1 + dx12 * (miny << 4) - dy12 * (minx << 4);
        int cy2 = c2 + dx23 * (miny << 4) - dy23 * (minx << 4);
        int cy3 = c3 + dx31 * (miny << 4) - dy31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int cx1 = cy1;
            int cx2 = cy2;
            int cx3 = cy3;
            float p = zoff + dy * (float)y;
            for (int x = minx; x < maxx; ++x) {
                if (cx1 > 0 && cx2 > 0 && cx3 > 0) {
                    int point = x + off;
                    float zval = p + dx * (float)x;
                    buff[point] = (int)(zval * 255.0f) << 24;
                }
                cx1 -= fdy12;
                cx2 -= fdy23;
                cx3 -= fdy31;
            }
            cy1 += fdx12;
            cy2 += fdx23;
            cy3 += fdx31;
            off += w;
        }
    }

    private void setScale(float minx, float maxx, float miny, float maxy) {
        this.mMinX = minx;
        this.mMaxX = maxx;
        this.mMinY = miny;
        this.mMaxY = maxy;
    }

    public void clear() {
        Arrays.fill(this.mData, 0);
    }
}

