/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.view.math.Math3DHelper;
import android.view.shadow.AmbientShadowConfig;

class AmbientShadowVertexCalculator {
    private final float[] mVertex;
    private final float[] mColor;
    private final int[] mIndex;
    private final AmbientShadowConfig mConfig;

    public AmbientShadowVertexCalculator(AmbientShadowConfig config) {
        this.mConfig = config;
        int rings = this.mConfig.getLayers() + 1;
        int size = this.mConfig.getRays() * rings;
        this.mVertex = new float[size * 2];
        this.mColor = new float[size * 4];
        this.mIndex = new int[(size * 2 + (this.mConfig.getRays() - 2)) * 3];
    }

    public boolean generateVertex(float[] polygon) {
        float[] centroidxy = new float[3];
        int polygonLength = polygon.length / 3;
        Math3DHelper.centroid3d(polygon, polygonLength, centroidxy);
        float cx = centroidxy[0];
        float cy = centroidxy[1];
        Rays rays = new Rays(this.mConfig.getRays());
        int raysLength = rays.dx.length;
        float[] rayDist = new float[this.mConfig.getRays()];
        float[] rayHeights = new float[this.mConfig.getRays()];
        for (int i = 0; i < raysLength; ++i) {
            float dx = rays.dx[i];
            float dy = rays.dy[i];
            float[] intersection = Math3DHelper.rayIntersectPoly(polygon, polygonLength, cx, cy, dx, dy, 3);
            if (intersection.length == 1) {
                return false;
            }
            rayDist[i] = intersection[0];
            int index = (int)(intersection[2] * 3.0f);
            int index2 = (int)((intersection[2] + 1.0f) % (float)polygonLength * 3.0f);
            float h1 = polygon[index + 2] * this.mConfig.getShadowBoundRatio();
            float h2 = polygon[index2 + 2] * this.mConfig.getShadowBoundRatio();
            rayHeights[i] = h1 + intersection[1] * (h2 - h1);
        }
        int rings = this.mConfig.getLayers() + 1;
        for (int i = 0; i < raysLength; ++i) {
            float dx = rays.dx[i];
            float dy = rays.dy[i];
            float cast = rayDist[i] * rayHeights[i];
            float opacity = 0.8f * (0.5f / (this.mConfig.getEdgeScale() / 10.0f));
            for (int j = 0; j < rings; ++j) {
                int p = i * rings + j;
                float jf = (float)j / (float)(rings - 1);
                float t = rayDist[i] + jf * (cast - rayDist[i]);
                this.mVertex[p * 2 + 0] = dx * t + cx;
                this.mVertex[p * 2 + 1] = dy * t + cy;
                this.mColor[p * 4 + 0] = 0.0f;
                this.mColor[p * 4 + 1] = 0.0f;
                this.mColor[p * 4 + 2] = 0.0f;
                this.mColor[p * 4 + 3] = (1.0f - jf) * opacity;
            }
        }
        int k = 0;
        for (int i = 0; i < this.mConfig.getRays(); ++i) {
            for (int j = 0; j < this.mConfig.getLayers(); ++j) {
                int r1 = j + rings * i;
                int r2 = j + rings * ((i + 1) % this.mConfig.getRays());
                this.mIndex[k * 3 + 0] = r1;
                this.mIndex[k * 3 + 1] = r1 + 1;
                this.mIndex[k * 3 + 2] = r2;
                this.mIndex[++k * 3 + 0] = r2;
                this.mIndex[k * 3 + 1] = r1 + 1;
                this.mIndex[k * 3 + 2] = r2 + 1;
                ++k;
            }
        }
        int ringOffset = 0;
        int i = 1;
        while (i < this.mConfig.getRays() - 1) {
            this.mIndex[k * 3 + 0] = ringOffset;
            this.mIndex[k * 3 + 1] = ringOffset + rings * i;
            this.mIndex[k * 3 + 2] = ringOffset + rings * (1 + i);
            ++i;
            ++k;
        }
        return true;
    }

    public int[] getIndex() {
        return this.mIndex;
    }

    public float[] getVertex() {
        return this.mVertex;
    }

    public float[] getColor() {
        return this.mColor;
    }

    private static class Rays {
        public final float[] dx;
        public final float[] dy;
        public final double deltaAngle;

        public Rays(int rays) {
            this.dx = new float[rays];
            this.dy = new float[rays];
            this.deltaAngle = Math.PI * 2 / (double)rays;
            for (int i = 0; i < rays; ++i) {
                this.dx[i] = (float)Math.sin(this.deltaAngle * (double)i);
                this.dy[i] = (float)Math.cos(this.deltaAngle * (double)i);
            }
        }
    }
}

